package com.ejianc.business.procurement.perform.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.procurement.perform.vo.RefundDepositDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 投标保证金退还
 * 
 * @author generator
 * 
 */
public class RefundDepositVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lotOpenDate; // 开标日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date calibrationDate; // 定标日期
    private String billCode; // 单据编号
    private String orgName; // 采购实施单位名称
    private String orgCode; // 采购实施单位编码
    private String employeeName; // 经办人名称
    private String businessType; // 标的物类别1-工程，2-货物，3-服务
    private String memo; // 备注
    private String purchaseProjectCode; // 采购项目名称
    private String lot; // 标段
    private String lotCode; // 标书编号
    private Integer lotNum; // 标段数量
    private Integer billState; // 单据状态
    private Long orgId; // 采购实施单位Id
    private Long employeeId; // 经办人
    private Long purchaseProjectId; // 采购项目id
    
    private List<RefundDepositDetailVO> refundDepositDetailList = new ArrayList<>(); // 投标保证金退还表明细

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public Date getLotOpenDate() {
        return lotOpenDate;
    }

    public void setLotOpenDate(Date lotOpenDate) {
        this.lotOpenDate = lotOpenDate;
    }
    public Date getCalibrationDate() {
        return calibrationDate;
    }

    public void setCalibrationDate(Date calibrationDate) {
        this.calibrationDate = calibrationDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public String getLot() {
        return lot;
    }

    public void setLot(String lot) {
        this.lot = lot;
    }
    public String getLotCode() {
        return lotCode;
    }

    public void setLotCode(String lotCode) {
        this.lotCode = lotCode;
    }
    public Integer getLotNum() {
        return lotNum;
    }

    public void setLotNum(Integer lotNum) {
        this.lotNum = lotNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }

    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    
     public List<RefundDepositDetailVO> getRefundDepositDetailList() {
        return refundDepositDetailList;
     }

     public void setRefundDepositDetailList(List<RefundDepositDetailVO> refundDepositDetailList) {
        this.refundDepositDetailList = refundDepositDetailList;
     }
}
