package com.ejianc.business.procurement.perform.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 非招标交易方式：询比采购、谈判采购、竞价采购、直接采购、简易采购
 * @author songlx
 * @date 2025/12/11
 * @version 1.0
 */
public enum NobidMethodEnum {

    XUN_BI(1, "询比采购"),
    TAN_PAN(2, "谈判采购"),
    JING_JIA(3, "竞价采购"),
    ZHI_JIE(4, "直接采购"),
    JIAN_YI(5, "简易采购");

    private static Map<Integer, NobidMethodEnum> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(NobidMethodEnum.class).stream().collect(Collectors.toMap(NobidMethodEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }


    public static String getNameByCode(Integer code) {
        return enumMap.get(code) != null ? enumMap.get(code).getName() : "未定义";
    }

    private Integer code;

    private String name;

    NobidMethodEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
