package com.ejianc.business.procurement.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购策划记录
 *
 * @author generator
 *
 */
public class PurchaseStrategyRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private BigDecimal preTaxMny; // 策划暂估金额(万元)
    private BigDecimal bidTaxMny; // 市场投标金额(万元)
    private BigDecimal subTaxMny; // 拟分包金额(万元)
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate; // 生效时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String curChangingPlanCode; // 变更编码
    private String billCode; // 单据编号
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private String parentOrgName; // 项目部上级名称
    private String parentOrgCode; // 项目部上级编码
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    private String employeeName; // 经办人名称
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private String memo; // 备注
    private Integer changeVersion; // 版本
    private Integer billState; // 单据状态
    private Integer changeState; // 变更状态: 0-未变更，1-变更中，2-已变更
    private Long curChangingPlanId; // 变更id
    private Long projectId; // 项目Id
    private Long orgId; // 项目部Id
    private Long parentOrgId; // 项目部上级Id
    private Long employeeId; // 经办人
    private Long sourcePlanId; // 原计划id

    private String changeReason; // 变更原因

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    private List<PurchaseStrategyRecordDetailVO> purchaseStrategyDetailList = new ArrayList<>(); // 采购策划记录-明细

    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }

    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }

    public BigDecimal getSubTaxMny() {
        return subTaxMny;
    }

    public void setSubTaxMny(BigDecimal subTaxMny) {
        this.subTaxMny = subTaxMny;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public String getCurChangingPlanCode() {
        return curChangingPlanCode;
    }

    public void setCurChangingPlanCode(String curChangingPlanCode) {
        this.curChangingPlanCode = curChangingPlanCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Long getCurChangingPlanId() {
        return curChangingPlanId;
    }

    public void setCurChangingPlanId(Long curChangingPlanId) {
        this.curChangingPlanId = curChangingPlanId;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }

    public List<PurchaseStrategyRecordDetailVO> getPurchaseStrategyDetailList() {
        return purchaseStrategyDetailList;
    }

    public void setPurchaseStrategyDetailList(List<PurchaseStrategyRecordDetailVO> purchaseStrategyDetailList) {
        this.purchaseStrategyDetailList = purchaseStrategyDetailList;
    }
}
