package com.ejianc.business.procurement.perform.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 采购结果审批-供应商
 * 
 * @author generator
 * 
 */
public class ResultSupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String sourceId; // 来源id
    private String sourceType; // 来源类型 0-新增，1-供应商库，2-邀请供应商，3-来源成交候选人，4-来源采购项目明细
    private Integer supplierBidFlag; // 是否中标:1-是，2-否
    private Integer candidateFlag; // 是否为成交候选人:1-是，2-否
    private Integer rankNum; // 排名
    private BigDecimal sellMny; // 无税总价
    private BigDecimal sellTaxMny; // 含税总价
    private BigDecimal totalScore; // 总分
    private BigDecimal technologyScore; // 技术分
    private BigDecimal businessScore; // 商务分
    private BigDecimal priceScore; // 价格分
    private Integer inStore; // 是否在库
    private Integer supplierSelectFlag; // 是否入围:1-是，2-否
    private Integer supplierFlag; // 是否符合:1-符合，2-不符合
    private Integer lot; // 标段
    private String socialCreditCode; // 统一社会信用代码
    private String supplierName; // 供应商name
    private Long supplierId; // 供应商id
    private Long pid; // 主表主键
    

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Integer getSupplierBidFlag() {
        return supplierBidFlag;
    }

    public void setSupplierBidFlag(Integer supplierBidFlag) {
        this.supplierBidFlag = supplierBidFlag;
    }
    public Integer getCandidateFlag() {
        return candidateFlag;
    }

    public void setCandidateFlag(Integer candidateFlag) {
        this.candidateFlag = candidateFlag;
    }
    public Integer getRankNum() {
        return rankNum;
    }

    public void setRankNum(Integer rankNum) {
        this.rankNum = rankNum;
    }
    public BigDecimal getSellMny() {
        return sellMny;
    }

    public void setSellMny(BigDecimal sellMny) {
        this.sellMny = sellMny;
    }
    public BigDecimal getSellTaxMny() {
        return sellTaxMny;
    }

    public void setSellTaxMny(BigDecimal sellTaxMny) {
        this.sellTaxMny = sellTaxMny;
    }
    public BigDecimal getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }
    public BigDecimal getTechnologyScore() {
        return technologyScore;
    }

    public void setTechnologyScore(BigDecimal technologyScore) {
        this.technologyScore = technologyScore;
    }
    public BigDecimal getBusinessScore() {
        return businessScore;
    }

    public void setBusinessScore(BigDecimal businessScore) {
        this.businessScore = businessScore;
    }
    public BigDecimal getPriceScore() {
        return priceScore;
    }

    public void setPriceScore(BigDecimal priceScore) {
        this.priceScore = priceScore;
    }
    public Integer getInStore() {
        return inStore;
    }

    public void setInStore(Integer inStore) {
        this.inStore = inStore;
    }
    public Integer getSupplierSelectFlag() {
        return supplierSelectFlag;
    }

    public void setSupplierSelectFlag(Integer supplierSelectFlag) {
        this.supplierSelectFlag = supplierSelectFlag;
    }
    public Integer getSupplierFlag() {
        return supplierFlag;
    }

    public void setSupplierFlag(Integer supplierFlag) {
        this.supplierFlag = supplierFlag;
    }
    public Integer getLot() {
        return lot;
    }

    public void setLot(Integer lot) {
        this.lot = lot;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
