/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procurement.plan.bean.CatalogCategoryEntity;
import com.ejianc.business.procurement.plan.service.ICatalogCategoryService;
import com.ejianc.business.procurement.plan.vo.CatalogCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"catalogCategory"})
public class CatalogCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "CATALOG_CATEGORY_CODE";
    @Autowired
    private ICatalogCategoryService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CatalogCategoryVO> saveOrUpdate(@RequestBody CatalogCategoryVO saveOrUpdateVO) {
        CatalogCategoryEntity entity = (CatalogCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CatalogCategoryEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)billCode.getData());
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.ne(entity.getId() != null, BaseEntity::getId, (Object)entity.getId());
            queryWrapper.eq(CatalogCategoryEntity::getCode, (Object)entity.getCode().trim());
            if (this.service.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
            }
        }
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
        }
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            CatalogCategoryEntity uniqueBean = (CatalogCategoryEntity)((Object)this.service.getById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.saveOrUpdate((Object)entity, false);
        CatalogCategoryVO vo = (CatalogCategoryVO)BeanMapper.map((Object)((Object)entity), CatalogCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CatalogCategoryVO> queryDetail(Long id) {
        CatalogCategoryEntity entity = (CatalogCategoryEntity)((Object)this.service.selectById(id));
        CatalogCategoryVO vo = (CatalogCategoryVO)BeanMapper.map((Object)((Object)entity), CatalogCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CatalogCategoryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CatalogCategoryVO vo : vos) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(CatalogCategoryEntity::getParentId, (Object)vo.getId());
                if (this.service.count((Wrapper)queryWrapper) <= 0) continue;
                return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List dataList = this.service.queryList(param);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CatalogCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCatalogCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refCatalogCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List dataList = null;
        try {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("enabled", new Parameter("eq", (Object)1));
            if (pid != null) {
                param.getParams().put("parentId", new Parameter("eq", (Object)pid));
            }
            dataList = this.service.queryList(param);
            List map = BeanMapper.mapList((Iterable)dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/enableOrDisable"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enableOrDisable(@RequestBody CatalogCategoryVO categoryVO) {
        if (categoryVO.getId() != null && categoryVO.getEnabled() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)categoryVO.getId());
            updateWrapper.set(CatalogCategoryEntity::getEnabled, (Object)categoryVO.getEnabled());
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

