package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.DemandPlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.DemandPlanEntity;
import com.ejianc.business.procurement.plan.service.IDemandPlanDetailService;
import com.ejianc.business.procurement.plan.service.IDemandPlanService;
import com.ejianc.business.procurement.plan.vo.DemandPlanDetailVO;
import com.ejianc.business.procurement.plan.vo.DemandPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 需求计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("demandPlan")
public class DemandPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IDemandPlanService service;

    @Autowired
    private IDemandPlanDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    private static Map<String, String> codeRuleMap = new HashMap<>();

    static {
        codeRuleMap.put("2", "DEMAND_PLAN_CODE");
        codeRuleMap.put("1", "DEMAND_PLAN_GC_CODE");
        codeRuleMap.put("3", "DEMAND_PLAN_FW_CODE");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DemandPlanVO> saveOrUpdate(@RequestBody DemandPlanVO saveOrUpdateVO) {
        DemandPlanEntity entity = BeanMapper.map(saveOrUpdateVO, DemandPlanEntity.class);
        if (StringUtils.isBlank(entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(codeRuleMap.get(entity.getBusinessType()), InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DemandPlanVO vo = BeanMapper.map(entity, DemandPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DemandPlanVO> queryDetail(Long id) {
        DemandPlanEntity entity = service.selectById(id);
        DemandPlanVO vo = BeanMapper.map(entity, DemandPlanVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DemandPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DemandPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DemandPlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DemandPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<DemandPlanEntity> page = service.queryPage(param, false);
        IPage<DemandPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DemandPlanVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DemandPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DemandPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDemandPlanData", method = RequestMethod.GET)
    @ResponseBody
    public List<DemandPlanVO> refDemandPlanData(@RequestParam(required = false) String searchText,
                                                @RequestParam(required = false) String condition) {

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if (_con.containsKey("orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<DemandPlanEntity> dataList = service.queryList(param);
        List<DemandPlanVO> list = BeanMapper.mapList(dataList, DemandPlanVO.class);
        if (CollectionUtil.isNotEmpty(list)) {
            for (DemandPlanVO vo : list) {
                vo.setName(vo.getBillCode());
            }
        }
        return list;
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDemandPlanDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DemandPlanDetailVO>> refDemandPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             @RequestParam(required = false) String relyCondition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        DemandPlanEntity planEntity = new DemandPlanEntity();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(relyCondition)) {
            Long planId = Long.valueOf(relyCondition.split("=")[1]);
            param.getParams().put("planId", new Parameter(QueryParam.EQ, planId));
            planEntity = service.selectById(planId);
        } else {
            throw new BusinessException("请选择左侧数据！");
        }
        IPage<DemandPlanDetailEntity> page = detailService.queryPage(param, false);
        IPage<DemandPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DemandPlanDetailVO> resList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resList = BeanMapper.mapList(page.getRecords(), DemandPlanDetailVO.class);
            for (DemandPlanDetailVO vo : resList) {
                vo.setBillCode(planEntity.getBillCode());
                vo.setProjectName(planEntity.getProjectName());
                vo.setAllOrgName(planEntity.getAllOrgName());
            }
        }
        pageData.setRecords(resList);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
