package com.ejianc.business.procurement.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procurement.plan.bean.CatalogCategoryEntity;
import com.ejianc.business.procurement.plan.bean.CatalogItemEntity;
import com.ejianc.business.procurement.plan.mapper.CatalogCategoryMapper;
import com.ejianc.business.procurement.plan.service.ICatalogCategoryService;
import com.ejianc.business.procurement.plan.service.ICatalogItemService;
import com.ejianc.business.procurement.plan.vo.CatalogCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 一级集采目录
 *
 * @author generator
 *
 */
@Service("catalogCategoryService")
public class CatalogCategoryServiceImpl extends BaseServiceImpl<CatalogCategoryMapper, CatalogCategoryEntity> implements ICatalogCategoryService {

    @Autowired
    private ICatalogItemService itemService;

    @Override
    public void enableOrDisable(CatalogCategoryVO categoryVO) {
        Long categoryVOId = categoryVO.getId();
        Integer enabled = categoryVO.getEnabled();
        CatalogCategoryEntity categoryEntity = this.getById(categoryVOId);
        if (categoryEntity != null) {
            LambdaQueryWrapper<CatalogCategoryEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.like(CatalogCategoryEntity::getInnerCode, categoryEntity.getInnerCode());
            queryWrapper.eq(CatalogCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
            List<CatalogCategoryEntity> categoryEntities = this.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(categoryEntities)) {
                List<Long> categoryIds = categoryEntities.stream().map(CatalogCategoryEntity::getId).collect(Collectors.toList());
                LambdaUpdateWrapper<CatalogItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(CatalogItemEntity::getCategoryId, categoryIds);
                updateWrapper.set(CatalogItemEntity::getEnabled, enabled);
                itemService.update(updateWrapper);
                LambdaUpdateWrapper<CatalogCategoryEntity> updater = new LambdaUpdateWrapper<>();
                updater.in(CatalogCategoryEntity::getId, categoryIds);
                updater.set(CatalogCategoryEntity::getEnabled, enabled);
                this.update(updater);
            }
        }
    }
}
