package com.ejianc.business.procurement.plan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.plan.bean.PurchasePlanDetailEntity;
import com.ejianc.business.procurement.plan.service.IPurchasePlanDetailService;
import com.ejianc.business.procurement.plan.vo.PurchasePlanDetailRefVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.business.procurement.plan.vo.PurchasePlanVO;

/**
 * 采购计划实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchasePlan")
public class PurchasePlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String HW_BILL_CODE = "PLAN_HW_CODE";
    private static final String GC_BILL_CODE = "PLAN_GC_CODE";
    private static final String FW_BILL_CODE = "PLAN_FW_CODE";

    @Autowired
    private IPurchasePlanService service;

    @Autowired
    private IPurchasePlanDetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasePlanVO> saveOrUpdate(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanEntity entity = BeanMapper.map(saveOrUpdateVO, PurchasePlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getBusinessType())){
                billcode = GC_BILL_CODE;
            }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                billcode = HW_BILL_CODE;
            }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PurchasePlanVO vo = BeanMapper.map(entity, PurchasePlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        PurchasePlanEntity entity = service.selectById(id);
        PurchasePlanVO vo = BeanMapper.map(entity, PurchasePlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasePlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PurchasePlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchasePlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PurchasePlanEntity> page = service.queryPage(param,false);
        IPage<PurchasePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasePlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchasePlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PurchasePlan-export.xlsx", beans, response);
    }


    /**
     * @Description queryDetail 查询详情
     * @param planIds
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PurchasePlanDetailRefVO>> queryDetailList(@RequestBody List<Long> planIds) {
        List<PurchasePlanDetailRefVO> resList = new ArrayList<>();
        planIds.forEach(planId->{
            PurchasePlanEntity planEntity = service.getById(planId);
            List<PurchasePlanDetailRefVO> detailList = new ArrayList<>();
            LambdaQueryWrapper<PurchasePlanDetailEntity> lambdachange = Wrappers.<PurchasePlanDetailEntity>lambdaQuery();
            lambdachange.eq(PurchasePlanDetailEntity::getPlanId, planId);
            lambdachange.eq(PurchasePlanDetailEntity::getAuthStatus, 2);
            lambdachange.eq(PurchasePlanDetailEntity::getAllocateStatus, 2);
            List<PurchasePlanDetailEntity> entityList = detailService.list(lambdachange);
            if(CollectionUtils.isNotEmpty(entityList)){
                detailList = BeanMapper.mapList(entityList, PurchasePlanDetailRefVO.class);
                for(PurchasePlanDetailRefVO vo:detailList){
                    vo.setBillCode(planEntity.getBillCode());
                    vo.setProjectName(planEntity.getProjectName());
                    vo.setAllOrgName(planEntity.getAllOrgName());
                    vo.setSpecialType(planEntity.getSpecialType());
                    vo.setSpecialCode(planEntity.getSpecialCode());
                    vo.setSpecialId(planEntity.getSpecialId());
                    vo.setSpecialMatter(planEntity.getSpecialMatter());
                    resList.add(vo);
                }
            }
        });
        return CommonResponse.success("查询详情数据成功！",resList);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPurchasePlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> refPurchasePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        Boolean flag = true;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("specialMatter")) {   // 特殊事项 1-拟邀请招标，2-拟不招标
                param.getParams().put("specialMatter", new Parameter(QueryParam.EQ, _con.get("specialMatter")));
            }
            if(_con.containsKey("answer")){
                flag=false;
            }
            if(_con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(_con.containsKey("businessType")){
                param.getParams().put("businessType", new Parameter(QueryParam.EQ, _con.get("businessType")));
            }
            if(_con.containsKey("orgId")){
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        if(flag){
            param.getParams().put("specialStatus", new Parameter(QueryParam.EQ, 1));// 特殊事项状态 1-未完成，2-已完成
            param.getParams().put("abnormalStatus", new Parameter(QueryParam.EQ, 1));// 计划异常状态 1-正常，2-取消采购，3-暂停采购
        }
        IPage<PurchasePlanEntity> page = service.queryPage(param,false);
        IPage<PurchasePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasePlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }



    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/purchasePlanRef", method = RequestMethod.GET)
    @ResponseBody
    public List<PurchasePlanVO> purchasePlanRef(@RequestParam(required = false) String searchText,
                                                @RequestParam(required = false) String condition) {

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("specialStatus", new Parameter(QueryParam.EQ, 1));// 特殊事项状态 1-未完成，2-已完成
        param.getParams().put("abnormalStatus", new Parameter(QueryParam.EQ, 1));// 计划异常状态 1-正常，2-取消采购，3-暂停采购
        Boolean flag = true;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(_con.containsKey("auth")){
                flag = false;
            }
            if(_con.containsKey("permissionType")){
                param.getParams().put("permissionType", new Parameter(QueryParam.EQ, _con.get("permissionType")));
            }
            if(_con.containsKey("businessType")){
                param.getParams().put("businessType", new Parameter(QueryParam.EQ, _con.get("businessType")));
            }
            if(_con.containsKey("orgId")){
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        if(flag){
            // 分配单参照时，只需要过滤 未分配
            param.getParams().put("allocateStatus", new Parameter(QueryParam.EQ, 2));// 是否已分配 1-是，2-否
        }else{
            param.getParams().put("authStatus", new Parameter(QueryParam.EQ, 2));// 是否已授权 1-是，2-否
            param.getParams().put("allocateStatus", new Parameter(QueryParam.EQ, 2));// 是否已分配 1-是，2-否
        }
        List<PurchasePlanEntity> dataList = service.queryList(param);
        List<PurchasePlanVO> list = BeanMapper.mapList(dataList,PurchasePlanVO.class);
        if (CollectionUtil.isNotEmpty(list)) {
            for (PurchasePlanVO vo : list) {
                vo.setName(vo.getBillCode());
            }
        }
        return list;
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/purchasePlanDetailsRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanDetailRefVO>> purchasePlanDetailsRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 @RequestParam(required = false) String relyCondition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        PurchasePlanEntity planEntity = new PurchasePlanEntity();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("authStatus", new Parameter(QueryParam.EQ, 2));// 是否已授权 1-是，2-否
        param.getParams().put("allocateStatus", new Parameter(QueryParam.EQ, 2));// 是否已分配 1-是，2-否
        Boolean flag = true;
        if(StringUtils.isNotEmpty(relyCondition)){
            Long planId = Long.valueOf(relyCondition.split("=")[1]);
            param.getParams().put("planId", new Parameter(QueryParam.EQ,planId));
            planEntity = service.selectById(planId);
        }else {
            throw new BusinessException("请选择左侧数据！");
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("auth")){
                flag = false;
            }
        }
        if(flag){
            // 分配单参照时，只需要过滤 未分配
            param.getParams().put("allocateStatus", new Parameter(QueryParam.EQ, 2));// 是否已分配 1-是，2-否
        }else{
            param.getParams().put("authStatus", new Parameter(QueryParam.EQ, 2));// 是否已授权 1-是，2-否
            param.getParams().put("allocateStatus", new Parameter(QueryParam.EQ, 2));// 是否已分配 1-是，2-否
        }
        IPage<PurchasePlanDetailEntity> page = detailService.queryPage(param,false);
        IPage<PurchasePlanDetailRefVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PurchasePlanDetailRefVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            resList = BeanMapper.mapList(page.getRecords(), PurchasePlanDetailRefVO.class);
            for(PurchasePlanDetailRefVO vo:resList){
                vo.setBillCode(planEntity.getBillCode());
                vo.setProjectName(planEntity.getProjectName());
                vo.setAllOrgName(planEntity.getAllOrgName());
                vo.setSpecialType(planEntity.getSpecialType());
                vo.setSpecialCode(planEntity.getSpecialCode());
                vo.setSpecialId(planEntity.getSpecialId());
            }
        }
        pageData.setRecords(resList);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
