/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.AuthapplyEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IAuthapplyService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanDetailService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.business.procurement.plan.vo.AuthapplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"authapply"})
public class AuthapplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_APPLY_BILL_CODE = "APPLY_HW_CODE";
    private static final String GC_APPLY_BILL_CODE = "APPLY_GC_CODE";
    private static final String FW_APPLY_BILL_CODE = "APPLY_FW_CODE";
    private static final String HW_WT_BILL_CODE = "WT_HW_CODE";
    private static final String GC_WT_BILL_CODE = "WT_GC_CODE";
    private static final String FW_WT_BILL_CODE = "WT_FW_CODE";
    @Autowired
    private IAuthapplyService service;
    @Autowired
    private IPurchasePlanService planService;
    @Autowired
    private IPurchasePlanDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AuthapplyVO> saveOrUpdate(@RequestBody AuthapplyVO saveOrUpdateVO) {
        AuthapplyEntity entity = (AuthapplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AuthapplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getAuthapplyType())) {
                if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                    billcode = GC_APPLY_BILL_CODE;
                } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                    billcode = HW_APPLY_BILL_CODE;
                } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                    billcode = FW_APPLY_BILL_CODE;
                }
            } else if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_WT_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_WT_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_WT_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAuthapplyDetailList())) {
            PurchasePlanEntity planEntity;
            List detailList;
            HashMap map = new HashMap();
            HashMap delMap = new HashMap();
            saveOrUpdateVO.getAuthapplyDetailList().forEach(e -> {
                if ("del".equals(e.getRowState())) {
                    if (delMap.containsKey(e.getSourceBillId())) {
                        List list = (List)delMap.get(e.getSourceBillId());
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(), list);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(), list);
                    }
                } else if (map.containsKey(e.getSourceBillId())) {
                    List list = (List)map.get(e.getSourceBillId());
                    list.add(e.getSourceId());
                    map.put(e.getSourceBillId(), list);
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(e.getSourceId());
                    map.put(e.getSourceBillId(), list);
                }
            });
            if (null != delMap && !delMap.isEmpty()) {
                for (String key : delMap.keySet()) {
                    detailList = (List)delMap.get(key);
                    planEntity = (PurchasePlanEntity)((Object)this.planService.selectById((Serializable)((Object)key)));
                    planEntity.getPurchasePlanDetailList().forEach(e -> {
                        if (detailList.contains(e.getId().toString())) {
                            e.setRowState("edit");
                            e.setAuthStatus(2);
                        }
                    });
                    planEntity.setAuthStatus(2);
                    this.planService.updateById((Object)planEntity);
                }
            }
            if (null != map && !map.isEmpty()) {
                this.logger.info("\u5f00\u59cb----");
                for (String key : map.keySet()) {
                    detailList = (List)map.get(key);
                    this.logger.info("detailList----" + JSONObject.toJSONString((Object)detailList));
                    planEntity = (PurchasePlanEntity)((Object)this.planService.selectById((Serializable)((Object)key)));
                    planEntity.getPurchasePlanDetailList().forEach(e -> {
                        this.logger.info("e.getId().toString()----" + e.getId().toString());
                        if (detailList.contains(e.getId().toString())) {
                            this.logger.info("\u5b50\u8868\u76f8\u7b49----");
                            e.setRowState("edit");
                            e.setAuthStatus(1);
                        }
                    });
                    Boolean flag = true;
                    this.logger.info("\u5b50\u8868\u4fe1\u606f----" + JSONObject.toJSONString(planEntity.getPurchasePlanDetailList()));
                    for (PurchasePlanDetailEntity detailEntity : planEntity.getPurchasePlanDetailList()) {
                        if (2 != detailEntity.getAuthStatus()) continue;
                        this.logger.info("\u5b50\u8868\u6709\u672a\u6388\u6743\u7684----");
                        flag = false;
                    }
                    if (flag.booleanValue()) {
                        planEntity.setAuthStatus(1);
                    }
                    this.planService.updateById((Object)planEntity);
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        AuthapplyVO vo = (AuthapplyVO)BeanMapper.map((Object)((Object)entity), AuthapplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AuthapplyVO> queryDetail(Long id) {
        AuthapplyEntity entity = (AuthapplyEntity)((Object)this.service.selectById(id));
        AuthapplyVO vo = (AuthapplyVO)BeanMapper.map((Object)((Object)entity), AuthapplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuthapplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            HashMap delMap = new HashMap();
            for (AuthapplyVO vo : vos) {
                AuthapplyEntity entity = (AuthapplyEntity)((Object)this.service.selectById(vo.getId()));
                entity.getAuthapplyDetailList().forEach(e -> {
                    if (delMap.containsKey(e.getSourceBillId())) {
                        List list = (List)delMap.get(e.getSourceBillId());
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(), list);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(), list);
                    }
                });
            }
            if (null != delMap && !delMap.isEmpty()) {
                for (String key : delMap.keySet()) {
                    List detailList = (List)delMap.get(key);
                    PurchasePlanEntity planEntity = (PurchasePlanEntity)((Object)this.planService.selectById((Serializable)((Object)key)));
                    planEntity.getPurchasePlanDetailList().forEach(e -> {
                        if (detailList.contains(e.getId().toString())) {
                            e.setAuthStatus(2);
                        }
                    });
                    planEntity.setAuthStatus(2);
                    this.planService.updateById((Object)planEntity);
                }
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AuthapplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AuthapplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Authapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAuthapplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AuthapplyVO>> refAuthapplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AuthapplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

