/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.PlanAllicateEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IPlanAllicateDetailService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.business.procurement.plan.vo.PlanAllicateVO;
import com.ejianc.business.procurement.plan.vo.PlanAllocateDetailRefVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planAllocate"})
public class PlanAllicateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_BILL_CODE = "HW_ALLICATE_CODE";
    private static final String GC_BILL_CODE = "GC_ALLICATE_CODE";
    private static final String FW_BILL_CODE = "FW_ALLICATE_CODE";
    @Autowired
    private IPlanAllicateService service;
    @Autowired
    private IPlanAllicateDetailService detailService;
    @Autowired
    private IPurchasePlanService planService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanAllicateVO> saveOrUpdate(@RequestBody PlanAllicateVO saveOrUpdateVO) {
        PlanAllicateEntity entity = (PlanAllicateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanAllicateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getPlanAllicateDetailList())) {
            PurchasePlanEntity planEntity;
            List detailList;
            HashMap map = new HashMap();
            HashMap delMap = new HashMap();
            saveOrUpdateVO.getPlanAllicateDetailList().forEach(e -> {
                if ("del".equals(e.getRowState())) {
                    if (delMap.containsKey(e.getPlanId().toString())) {
                        List list = (List)delMap.get(e.getPlanId().toString());
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(), list);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(), list);
                    }
                } else if (map.containsKey(e.getPlanId().toString())) {
                    List list = (List)map.get(e.getPlanId().toString());
                    list.add(e.getSourceId());
                    map.put(e.getPlanId().toString(), list);
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(e.getSourceId());
                    map.put(e.getPlanId().toString(), list);
                }
            });
            if (!delMap.isEmpty()) {
                for (String key : delMap.keySet()) {
                    detailList = (List)delMap.get(key);
                    planEntity = (PurchasePlanEntity)((Object)this.planService.selectById((Serializable)((Object)key)));
                    planEntity.getPurchasePlanDetailList().forEach(e -> {
                        if (detailList.contains(e.getId().toString())) {
                            e.setAuthStatus(2);
                        }
                    });
                    planEntity.setAuthStatus(2);
                    this.planService.saveOrUpdate((Object)planEntity, false);
                }
            }
            if (!map.isEmpty()) {
                for (String key : map.keySet()) {
                    detailList = (List)map.get(key);
                    planEntity = (PurchasePlanEntity)((Object)this.planService.selectById((Serializable)((Object)key)));
                    planEntity.getPurchasePlanDetailList().forEach(e -> {
                        if (detailList.contains(e.getId().toString())) {
                            e.setAllocateStatus(1);
                        }
                    });
                    boolean flag = true;
                    for (PurchasePlanDetailEntity detailEntity : planEntity.getPurchasePlanDetailList()) {
                        if (2 != detailEntity.getAllocateStatus()) continue;
                        this.logger.info("\u5b50\u8868\u6709\u672a\u6388\u6743\u7684----");
                        flag = false;
                    }
                    if (flag) {
                        planEntity.setAllocateStatus(1);
                    }
                    this.planService.saveOrUpdate((Object)planEntity, false);
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlanAllicateVO vo = (PlanAllicateVO)BeanMapper.map((Object)((Object)entity), PlanAllicateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanAllicateVO> queryDetail(Long id) {
        PlanAllicateEntity entity = (PlanAllicateEntity)((Object)this.service.selectById(id));
        PlanAllicateVO vo = (PlanAllicateVO)BeanMapper.map((Object)((Object)entity), PlanAllicateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanAllicateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            HashMap delMap = new HashMap();
            for (PlanAllicateVO vo : vos) {
                PlanAllicateEntity entity = (PlanAllicateEntity)((Object)this.service.selectById(vo.getId()));
                entity.getPlanAllicateDetailList().forEach(e -> {
                    if (delMap.containsKey(e.getPlanId().toString())) {
                        List list = (List)delMap.get(e.getPlanId().toString());
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(), list);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(), list);
                    }
                });
            }
            if (!delMap.isEmpty()) {
                for (String key : delMap.keySet()) {
                    List detailList = (List)delMap.get(key);
                    PurchasePlanEntity planEntity = (PurchasePlanEntity)((Object)this.planService.selectById((Serializable)((Object)key)));
                    planEntity.getPurchasePlanDetailList().forEach(e -> {
                        if (detailList.contains(e.getId().toString())) {
                            e.setAllocateStatus(2);
                        }
                    });
                    planEntity.setAllocateStatus(2);
                    this.planService.saveOrUpdate((Object)planEntity, false);
                }
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanAllicateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanAllicateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PlanAllicate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanAllocateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PlanAllicateVO>> refPlanAllocateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("abnormalStatus", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        List dataList = this.service.queryList(param);
        List pageData = BeanMapper.mapList((Iterable)dataList, PlanAllicateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/planAllocateDetailRefVORef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanAllocateDetailRefVO>> planAllocateDetailRefVORef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("allocateStatus", new Parameter("eq", (Object)2));
        Boolean flag = true;
        if (!StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5de6\u4fa7\u6570\u636e\uff01");
        }
        Long allocateId = Long.valueOf(relyCondition.split("=")[1]);
        param.getParams().put("pid", new Parameter("eq", (Object)allocateId));
        PlanAllicateEntity allicateEntity = (PlanAllicateEntity)((Object)this.service.selectById(allocateId));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            allocateId = JSONObject.parseObject((String)condition);
        }
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resList = BeanMapper.mapList((Iterable)page.getRecords(), PlanAllocateDetailRefVO.class);
            for (PlanAllocateDetailRefVO vo : resList) {
                vo.setAllocateId(allicateEntity.getId());
            }
        }
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

