package com.ejianc.business.procurement.plan.controller;

import java.io.Serializable;

import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.IPlanAllicateDetailService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.business.procurement.plan.vo.AuthapplyVO;
import com.ejianc.business.procurement.plan.vo.PlanAllocateDetailRefVO;
import com.ejianc.business.procurement.plan.vo.PurchasePlanDetailRefVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.plan.service.IPlanAllicateService;
import com.ejianc.business.procurement.plan.vo.PlanAllicateVO;

/**
 * 采购计划分配
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("planAllocate")
public class PlanAllicateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_BILL_CODE = "HW_ALLICATE_CODE";
    private static final String GC_BILL_CODE = "GC_ALLICATE_CODE";
    private static final String FW_BILL_CODE = "FW_ALLICATE_CODE";

    @Autowired
    private IPlanAllicateService service;

    @Autowired
    private IPlanAllicateDetailService detailService;
    @Autowired
    private IPurchasePlanService planService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanAllicateVO> saveOrUpdate(@RequestBody PlanAllicateVO saveOrUpdateVO) {
    	PlanAllicateEntity entity = BeanMapper.map(saveOrUpdateVO, PlanAllicateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getBusinessType())){
                billcode = GC_BILL_CODE;
            }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                billcode = HW_BILL_CODE;
            }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //将计划子表改为已分配
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getPlanAllicateDetailList())){
            Map<String,List<String>> map = new HashMap<>();
            Map<String,List<String>> delMap = new HashMap<>();
            saveOrUpdateVO.getPlanAllicateDetailList().forEach(e->{
                if("del".equals(e.getRowState())){
                    if(delMap.containsKey(e.getPlanId().toString())){
                        List<String> list = delMap.get(e.getPlanId().toString());
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(),list);
                    }else{
                        List<String> list = new ArrayList<>();
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(),list);
                    }
                }else{
                    if(map.containsKey(e.getPlanId().toString())){
                        List<String> list = map.get(e.getPlanId().toString());
                        list.add(e.getSourceId());
                        map.put(e.getPlanId().toString(),list);
                    }else{
                        List<String> list = new ArrayList<>();
                        list.add(e.getSourceId());
                        map.put(e.getPlanId().toString(),list);
                    }
                }
            });

            if(!delMap.isEmpty()){
                for(String key:delMap.keySet()){
                    List<String> detailList = delMap.get(key);
                    PurchasePlanEntity planEntity =  planService.selectById(key);
                    planEntity.getPurchasePlanDetailList().forEach(e->{
                        if(detailList.contains(e.getId().toString())){
                            e.setAuthStatus(2);
                        }
                    });
                    planEntity.setAuthStatus(2);
                    planService.saveOrUpdate(planEntity,false);
                }
            }
            if(!map.isEmpty()){
                for(String key:map.keySet()){
                    List<String> detailList = map.get(key);
                    PurchasePlanEntity planEntity =  planService.selectById(key);
                    planEntity.getPurchasePlanDetailList().forEach(e->{
                        if(detailList.contains(e.getId().toString())){
                            e.setAllocateStatus(1);
                        }
                    });
                    boolean flag = true;
                    for(PurchasePlanDetailEntity detailEntity:planEntity.getPurchasePlanDetailList()){
                        if(2==detailEntity.getAllocateStatus()){
                            logger.info("子表有未授权的----");
                            flag = false;
                        }
                    }
                    if(flag){
                        //如果子表全部已分配，则需要将主表也改为已分配
                        planEntity.setAllocateStatus(1);
                    }
                    planService.saveOrUpdate(planEntity,false);
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	PlanAllicateVO vo = BeanMapper.map(entity, PlanAllicateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanAllicateVO> queryDetail(Long id) {
    	PlanAllicateEntity entity = service.selectById(id);
    	PlanAllicateVO vo = BeanMapper.map(entity, PlanAllicateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanAllicateVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            Map<String,List<String>> delMap = new HashMap<>();
            for (PlanAllicateVO vo : vos) {
                PlanAllicateEntity entity = service.selectById(vo.getId());
                entity.getPlanAllicateDetailList().forEach(e->{
                    if(delMap.containsKey(e.getPlanId().toString())){
                        List<String> list = delMap.get(e.getPlanId().toString());
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(),list);
                    }else{
                        List<String> list = new ArrayList<>();
                        list.add(e.getSourceId());
                        delMap.put(e.getPlanId().toString(),list);
                    }
                });
            }
            if(!delMap.isEmpty()){
                for(String key:delMap.keySet()){
                    List<String> detailList = delMap.get(key);
                    PurchasePlanEntity planEntity =  planService.selectById(key);
                    planEntity.getPurchasePlanDetailList().forEach(e->{
                        if(detailList.contains(e.getId().toString())){
                            e.setAllocateStatus(2);
                        }
                    });
                    planEntity.setAllocateStatus(2);
                    planService.saveOrUpdate(planEntity,false);
                }
            }
        }
        service.removeByIds(vos.stream().map(PlanAllicateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanAllicateVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        IPage<PlanAllicateEntity> page = service.queryPage(param,false);
        IPage<PlanAllicateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanAllicateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanAllicateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PlanAllicate-export.xlsx", beans, response);
    }

    /**
     * @Description 采购分配主表参照
     * @Return void
     */
    @RequestMapping(value = "/refPlanAllocateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PlanAllicateVO>> refPlanAllocateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("abnormalStatus", new Parameter(QueryParam.EQ, 1));// 计划异常状态 1-正常，2-取消采购，3-暂停采购

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        List<PlanAllicateEntity> dataList = service.queryList(param);
        List<PlanAllicateVO> pageData = BeanMapper.mapList(dataList, PlanAllicateVO.class);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照 采购分配详细表
     * @Return void
     */
    @RequestMapping(value = "/planAllocateDetailRefVORef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanAllocateDetailRefVO>> planAllocateDetailRefVORef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 @RequestParam(required = false) String relyCondition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        PlanAllicateEntity allicateEntity;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("SQL", new Parameter(QueryParam.SQL, " num > executed_num "));// 采购数量 > 已执行采购数量
        Boolean flag = true;
        if(StringUtils.isNotEmpty(relyCondition)){
            Long allocateId = Long.valueOf(relyCondition.split("=")[1]);
            param.getParams().put("pid", new Parameter(QueryParam.EQ,allocateId));
            allicateEntity = service.selectById(allocateId);
        }else {
            throw new BusinessException("请选择左侧数据！");
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<PlanAllicateDetailEntity> page = detailService.queryPage(param,false);
        IPage<PlanAllocateDetailRefVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlanAllocateDetailRefVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            resList = BeanMapper.mapList(page.getRecords(), PlanAllocateDetailRefVO.class);
            for(PlanAllocateDetailRefVO vo:resList){
                vo.setAllocateId(allicateEntity.getId());
            }
        }
        pageData.setRecords(resList);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
