package com.ejianc.business.procurement.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("authapply") 
public class AuthapplyBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAuthapplyService service;
	@Autowired
	private IPurchasePlanService planService;
	@Autowired
	private IPurchasePlanDetailService planDetailService;
	@Autowired
	private IPlanAllicateDetailService planAllicateDetailService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//回写采购计划子表的 授权实施权限
		AuthapplyEntity entity = service.selectById(billId);
		if(CollectionUtils.isNotEmpty(entity.getAuthapplyDetailList())){
			for(AuthapplyDetailEntity detailEntity:entity.getAuthapplyDetailList()){
				LambdaUpdateWrapper<PurchasePlanDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.in(PurchasePlanDetailEntity::getId, detailEntity.getSourceId());
				updateWrapper.set(PurchasePlanDetailEntity::getAuthPermissionType, detailEntity.getAuthPermissionType());
				planDetailService.update(updateWrapper);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		AuthapplyEntity entity = service.selectById(billId);
		if(CollectionUtils.isNotEmpty(entity.getAuthapplyDetailList())){
			List<String> planIds = entity.getAuthapplyDetailList().stream().map(AuthapplyDetailEntity::getSourceBillId).collect(Collectors.toList());
			LambdaQueryWrapper<PurchasePlanEntity> lambdachange = Wrappers.<PurchasePlanEntity>lambdaQuery();
			lambdachange.in(PurchasePlanEntity::getId, planIds);
			lambdachange.ne(PurchasePlanEntity::getAbnormalStatus, 1);
			List<PurchasePlanEntity> entityList = planService.list(lambdachange);
			if(CollectionUtils.isNotEmpty(entityList)){
				return CommonResponse.error("清单对应的采购计划存在异常状态，不允许弃审操作！");
			}
			LambdaQueryWrapper<PlanAllicateDetailEntity> lambdachange2 = Wrappers.<PlanAllicateDetailEntity>lambdaQuery();
			lambdachange2.in(PlanAllicateDetailEntity::getPlanId, planIds);
			List<PlanAllicateDetailEntity> detailEntityList = planAllicateDetailService.list(lambdachange2);
			if(CollectionUtils.isNotEmpty(detailEntityList)){
				return CommonResponse.error("清单对应的采购计划已被分配，不允许弃审操作！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//回写采购计划子表的 授权实施权限  赋值为 采购计划实施权限字段
		AuthapplyEntity entity = service.selectById(billId);
		if(CollectionUtils.isNotEmpty(entity.getAuthapplyDetailList())){
			for(AuthapplyDetailEntity detailEntity:entity.getAuthapplyDetailList()){
				LambdaUpdateWrapper<PurchasePlanDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.in(PurchasePlanDetailEntity::getId, detailEntity.getSourceId());
				updateWrapper.setSql(" auth_permission_type=plan_permission_type");
//				updateWrapper.set(PurchasePlanDetailEntity::getAuthPermissionType, PurchasePlanDetailEntity::getPlanPermissionType);
				planDetailService.update(updateWrapper);
			}
		}
		return CommonResponse.success();
	}

}
