package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.DemandPlanEntity;
import com.ejianc.business.procurement.plan.service.IDemandPlanService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("demandPlan")
public class DemandPlanBpmServiceImpl implements ICommonBusinessService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IPushMessageApi pushMessageApi;


    @Autowired
    private IDemandPlanService service;

    @Value("${common.env.base-host}")
    private String baseHost;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }


    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId    //单据id
     * @param state        //单据状态
     * @param billTypeCode        //单据类型code
     * @param taskId        //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }


    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DemandPlanEntity entity = service.getById(billId);
        String billCode = entity.getBillCode();
        String businessType = entity.getBusinessType();
        logger.info("发送消息开始========= id = " + entity.getId() + "，billCode = " + billCode);
        Long noticeId = entity.getNoticeId();
        String employeeName = entity.getEmployeeName();
        if (noticeId != null) {
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
            String[] receivers = String.valueOf(noticeId).split(",");

            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");
            String urlRoute = "demandPlanGoods";
            if("1".equals(businessType)){
                urlRoute = "demandPlanProject";
            } else if("3".equals(businessType)) {
                urlRoute = "demandPlanService";
            }

            String url = baseHost + "ejc-procurement-frontend/#/" + urlRoute + "/card?id=" + billId;
            parameter.setPcUrl(url);
            parameter.setMobileUrl(baseHost + "ejc-procurement-mobile/#/" + urlRoute + "/card?id=" + billId);
            parameter.setSubject(employeeName + "提交的【需求计划（货物、工程、服务）——单据编号:" + billCode + "】已审批通过，请知晓！");// 标题
            String sysContent = parameter.getSubject() + "<a href=" + '"' + url + '"' + ">点击查看详情</a>";
            parameter.setContent(sysContent);// 内容
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    logger.info("消息发送成功---------------->" + result.getMsg());
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
