package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.InvitedTenderMatterEntity;
import com.ejianc.business.procurement.plan.bean.UnTenderMatterEntity;
import com.ejianc.business.procurement.plan.service.IInvitedTenderMatterService;
import com.ejianc.business.procurement.plan.service.IUnTenderMatterService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("unTenderMatter") 
public class UnTenderMatterBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IUnTenderMatterService service;
	@Autowired
	private IInvitedTenderMatterService invitedTenderMatterService;
	@Autowired
	private IBillTypeApi billTypeApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		UnTenderMatterEntity entity = service.selectById(billId);
		invitedTenderMatterService.UPDPurchasePlan(entity.getPlanId(),entity.getId(),entity.getBillCode(),Boolean.TRUE);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		UnTenderMatterEntity entity = service.selectById(billId);
		//校验采购计划下游是否被引用
		QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
		quoteParamsVO.setBillIds(Arrays.asList(entity.getPlanId()));
		quoteParamsVO.setBillTypeCode("BT202512000005");
		CommonResponse<List<Long>> resp = billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
		if(!resp.isSuccess()){
			return CommonResponse.error("查询引用校验失败！");
		} else {
			List<Long> resultIds = new ArrayList<>();
			List<Long> quoteIds = resp.getData();
			resultIds.addAll(quoteIds);
			resultIds.remove(billId);
			if (resultIds.size()>0){
				return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
			}
		}
		invitedTenderMatterService.UPDPurchasePlan(entity.getPlanId(),entity.getId(),entity.getBillCode(),Boolean.FALSE);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
