/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.ExecutePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.ExecutePlanEntity;
import com.ejianc.business.procurement.plan.bean.PlanAllicateDetailEntity;
import com.ejianc.business.procurement.plan.bean.PlanAllicateEntity;
import com.ejianc.business.procurement.plan.bean.PlanExceptionDetailEntity;
import com.ejianc.business.procurement.plan.bean.PlanExceptionEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IExecutePlanDetailService;
import com.ejianc.business.procurement.plan.service.IExecutePlanService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateDetailService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateService;
import com.ejianc.business.procurement.plan.service.IPlanExceptionService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planException")
public class PlanExceptionBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPlanExceptionService service;
    @Autowired
    private IPurchasePlanService planService;
    @Autowired
    private IPlanAllicateService allocateService;
    @Autowired
    private IPlanAllicateDetailService allocateDetailService;
    @Autowired
    private IExecutePlanService executePlanService;
    @Autowired
    private IExecutePlanDetailService executePlanDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4e0d\u652f\u6301\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PlanExceptionEntity planExceptionEntity = (PlanExceptionEntity)((Object)this.service.selectById(billId));
        if (planExceptionEntity.getAbnormalStatus() == 2) {
            List executePlanIdList;
            PurchasePlanEntity purchasePlanEntity = (PurchasePlanEntity)((Object)this.planService.selectById(planExceptionEntity.getPlanId()));
            purchasePlanEntity.setAbnormalStatus(2);
            this.planService.saveOrUpdate((Object)purchasePlanEntity, false);
            if (ListUtil.isNotEmpty(planExceptionEntity.getPlanExceptionDetailList()) && ListUtil.isNotEmpty(executePlanIdList = planExceptionEntity.getPlanExceptionDetailList().stream().filter(PlanExceptionDetailEntity::getClosed).map(PlanExceptionDetailEntity::getSourceId).distinct().collect(Collectors.toList()))) {
                QueryParam param = new QueryParam();
                param.getParams().put("id", new Parameter("in", executePlanIdList));
                List executePlanList = this.executePlanService.queryList(param, false);
                for (Object executePlanEntity : executePlanList) {
                    ((ExecutePlanEntity)((Object)executePlanEntity)).setAbnormalStatus(2);
                }
                this.executePlanService.saveOrUpdateBatch(executePlanList);
                param = new QueryParam();
                param.getParams().put("pid", new Parameter("in", executePlanIdList));
                param.getParams().put("planId", new Parameter("ne", (Object)planExceptionEntity.getPlanId()));
                List executePlanDetailList = this.executePlanDetailService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)executePlanDetailList)) {
                    Object executePlanEntity;
                    executePlanEntity = executePlanDetailList.iterator();
                    while (executePlanEntity.hasNext()) {
                        ExecutePlanDetailEntity executePlanDetailEntity = (ExecutePlanDetailEntity)((Object)executePlanEntity.next());
                        param = new QueryParam();
                        param.getParams().put("sourceId", new Parameter("eq", (Object)executePlanDetailEntity.getSourceId()));
                        param.getParams().put("id", new Parameter("ne", (Object)executePlanDetailEntity.getId()));
                        List executePlanDetail = this.executePlanDetailService.queryList(param, false);
                        BigDecimal executeNum = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty((Collection)executePlanDetail)) {
                            executeNum = executePlanDetail.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        PlanAllicateDetailEntity detailEntity = (PlanAllicateDetailEntity)((Object)this.allocateDetailService.selectById((Serializable)((Object)executePlanDetailEntity.getSourceId())));
                        detailEntity.setExecutedNum(executeNum);
                        executePlanDetailEntity.setExecuteNum(BigDecimal.ZERO);
                        this.executePlanDetailService.saveOrUpdate((Object)executePlanDetailEntity, false);
                        this.allocateDetailService.saveOrUpdate((Object)detailEntity, false);
                    }
                }
            }
            QueryParam param = new QueryParam();
            param.getParams().put("planId", new Parameter("eq", (Object)planExceptionEntity.getPlanId()));
            List allocateDetailEntities = this.allocateDetailService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)allocateDetailEntities)) {
                param = new QueryParam();
                param.getParams().put("id", new Parameter("in", allocateDetailEntities.stream().map(PlanAllicateDetailEntity::getPid).collect(Collectors.toList())));
                List allocateList = this.allocateService.queryList(param, false);
                for (PlanAllicateEntity allocateEntity : allocateList) {
                    allocateEntity.setAbnormalStatus(2);
                }
                this.allocateService.saveOrUpdateBatch(allocateList);
            }
        } else if (planExceptionEntity.getAbnormalStatus() == 4) {
            List executePlanIdList;
            if (ListUtil.isNotEmpty(planExceptionEntity.getPlanExceptionDetailList()) && ListUtil.isNotEmpty(executePlanIdList = planExceptionEntity.getPlanExceptionDetailList().stream().filter(PlanExceptionDetailEntity::getClosed).map(PlanExceptionDetailEntity::getSourceId).distinct().collect(Collectors.toList()))) {
                QueryParam param = new QueryParam();
                param.getParams().put("id", new Parameter("in", executePlanIdList));
                List executePlanList = this.executePlanService.queryList(param, false);
                for (Object executePlanEntity : executePlanList) {
                    ((ExecutePlanEntity)((Object)executePlanEntity)).setAbnormalStatus(4);
                }
                this.executePlanService.saveOrUpdateBatch(executePlanList);
                param = new QueryParam();
                param.getParams().put("pid", new Parameter("in", executePlanIdList));
                List executePlanDetailList = this.executePlanDetailService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)executePlanDetailList)) {
                    for (ExecutePlanDetailEntity executePlanDetailEntity : executePlanDetailList) {
                        param = new QueryParam();
                        param.getParams().put("sourceId", new Parameter("eq", (Object)executePlanDetailEntity.getSourceId()));
                        param.getParams().put("id", new Parameter("ne", (Object)executePlanDetailEntity.getId()));
                        List executePlanDetail = this.executePlanDetailService.queryList(param, false);
                        BigDecimal executeNum = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty((Collection)executePlanDetail)) {
                            executeNum = executePlanDetail.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        PlanAllicateDetailEntity detailEntity = (PlanAllicateDetailEntity)((Object)this.allocateDetailService.selectById((Serializable)((Object)executePlanDetailEntity.getSourceId())));
                        detailEntity.setExecutedNum(executeNum);
                        executePlanDetailEntity.setExecuteNum(BigDecimal.ZERO);
                        this.executePlanDetailService.saveOrUpdate((Object)executePlanDetailEntity, false);
                        this.allocateDetailService.saveOrUpdate((Object)detailEntity, false);
                    }
                }
            }
        } else if (planExceptionEntity.getAbnormalStatus() == 3) {
            List allocateDetailList;
            PurchasePlanEntity purchasePlanEntity = (PurchasePlanEntity)((Object)this.planService.selectById(planExceptionEntity.getPlanId()));
            purchasePlanEntity.setAbnormalStatus(3);
            this.planService.saveOrUpdate((Object)purchasePlanEntity, false);
            QueryParam param = new QueryParam();
            param.getParams().put("planId", new Parameter("eq", (Object)planExceptionEntity.getPlanId()));
            List executePlanDetailList = this.executePlanDetailService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)executePlanDetailList)) {
                param = new QueryParam();
                param.getParams().put("id", new Parameter("in", executePlanDetailList.stream().map(ExecutePlanDetailEntity::getPid).collect(Collectors.toList())));
                List executePlanList = this.executePlanService.queryList(param, false);
                for (ExecutePlanEntity executePlanEntity : executePlanList) {
                    executePlanEntity.setAbnormalStatus(3);
                }
                this.executePlanService.saveOrUpdateBatch(executePlanList);
            }
            if (ListUtil.isNotEmpty((List)(allocateDetailList = this.allocateDetailService.queryList(param, false)))) {
                param = new QueryParam();
                param.getParams().put("id", new Parameter("in", allocateDetailList.stream().map(PlanAllicateDetailEntity::getPid).collect(Collectors.toList())));
                List allocateList = this.allocateService.queryList(param, false);
                for (PlanAllicateEntity allocateEntity : allocateList) {
                    allocateEntity.setAbnormalStatus(3);
                }
                this.allocateService.saveOrUpdateBatch(allocateList);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4e0d\u652f\u6301\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

