package com.ejianc.business.procurement.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("invitedTenderMatter") 
public class InvitedTenderMatterBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IInvitedTenderMatterService service;
	@Autowired
	private IAuthapplyDetailService authapplyDetailService;
	@Autowired
	private IPlanAllicateDetailService planAllicateDetailService;
	@Autowired
	private IPurchasePlanService planService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		InvitedTenderMatterEntity entity = service.selectById(billId);
		service.UPDPurchasePlan(entity.getPlanId(),entity.getId(),entity.getBillCode(),Boolean.TRUE);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		InvitedTenderMatterEntity entity = service.selectById(billId);
		//校验采购计划下游是否被引用
		// 1，授权申请/委托
		//2，授权分配
		//3，采购计划 为正常状态
		int count =0;
		LambdaQueryWrapper<AuthapplyDetailEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
		lambdaQueryWrapper.eq(AuthapplyDetailEntity::getSourceBillId,entity.getPlanId())
				.eq(AuthapplyDetailEntity::getDr, 0);
		count = count+authapplyDetailService.count(lambdaQueryWrapper);
		LambdaQueryWrapper<PlanAllicateDetailEntity> lambdaQueryWrapper1 = Wrappers.lambdaQuery();
		lambdaQueryWrapper1.eq(PlanAllicateDetailEntity::getPlanId,entity.getPlanId())
				.eq(PlanAllicateDetailEntity::getDr, 0);
		count = count+planAllicateDetailService.count(lambdaQueryWrapper1);
		LambdaQueryWrapper<PurchasePlanEntity> lambdaQueryWrapper2 = Wrappers.lambdaQuery();
		lambdaQueryWrapper2.eq(PurchasePlanEntity::getId,entity.getPlanId())
				.eq(PurchasePlanEntity::getDr, 0)
				.eq(PurchasePlanEntity::getAbnormalStatus, 1);
		count = count+planService.count(lambdaQueryWrapper2);
		if (count>0){
			throw new BusinessException("该采购计划已存在业务单据");
		}
		service.UPDPurchasePlan(entity.getPlanId(),entity.getId(),entity.getBillCode(),Boolean.FALSE);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
