/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.ExecutePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.ExecutePlanEntity;
import com.ejianc.business.procurement.plan.bean.PlanAllicateDetailEntity;
import com.ejianc.business.procurement.plan.service.IExecutePlanDetailService;
import com.ejianc.business.procurement.plan.service.IExecutePlanService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateDetailService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateService;
import com.ejianc.business.procurement.plan.vo.ExecutePlanDetailVO;
import com.ejianc.business.procurement.plan.vo.ExecutePlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"executePlan"})
public class ExecutePlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_BILL_CODE = "HW_EXE_CODE";
    private static final String GC_BILL_CODE = "GC_EXE_CODE";
    private static final String FW_BILL_CODE = "FW_EXE_CODE";
    @Autowired
    private IExecutePlanService service;
    @Autowired
    private IExecutePlanDetailService executePlanDetailService;
    @Autowired
    private IPlanAllicateService allocateService;
    @Autowired
    private IPlanAllicateDetailService allocateDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExecutePlanVO> saveOrUpdate(@RequestBody ExecutePlanVO saveOrUpdateVO) {
        ExecutePlanEntity entity = (ExecutePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ExecutePlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getExecutePlanDetailList())) {
            QueryParam param = new QueryParam();
            saveOrUpdateVO.getExecutePlanDetailList().forEach(e -> {
                param.getParams().put("sourceId", Parameter.getEqInstance((Object)e.getSourceId()));
                param.getParams().put("id", new Parameter("ne", (Object)e.getId()));
                List list = this.executePlanDetailService.queryList(param, false);
                BigDecimal executeNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    executeNum = list.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                PlanAllicateDetailEntity detailEntity = (PlanAllicateDetailEntity)((Object)((Object)this.allocateDetailService.selectById((Serializable)((Object)e.getSourceId()))));
                if ("del".equals(e.getRowState())) {
                    detailEntity.setExecutedNum(executeNum);
                } else {
                    if (detailEntity.getNum().compareTo(e.getExecuteNum().add(executeNum)) < 0) {
                        throw new BusinessException("\u672c\u6b21\u6267\u884c\u6570\u91cf[" + e.getExecuteNum() + "]\u4e0d\u80fd\u5927\u4e8e\u5b9e\u9645\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf[" + detailEntity.getNum().subtract(executeNum).setScale(2, RoundingMode.HALF_UP) + "]");
                    }
                    detailEntity.setExecutedNum(e.getExecuteNum().add(executeNum));
                }
                this.allocateDetailService.saveOrUpdate((Object)detailEntity, false);
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        ExecutePlanVO vo = (ExecutePlanVO)BeanMapper.map((Object)((Object)entity), ExecutePlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecutePlanVO> queryDetail(Long id) {
        ExecutePlanEntity entity = (ExecutePlanEntity)((Object)this.service.selectById(id));
        ExecutePlanVO vo = (ExecutePlanVO)BeanMapper.map((Object)((Object)entity), ExecutePlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecutePlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ExecutePlanVO vo : vos) {
                ExecutePlanEntity entity = (ExecutePlanEntity)((Object)this.service.selectById(vo.getId()));
                if (!CollectionUtils.isNotEmpty(entity.getExecutePlanDetailList())) continue;
                QueryParam param = new QueryParam();
                entity.getExecutePlanDetailList().forEach(e -> {
                    PlanAllicateDetailEntity detailEntity = (PlanAllicateDetailEntity)((Object)((Object)this.allocateDetailService.selectById((Serializable)((Object)e.getSourceId()))));
                    param.getParams().put("sourceId", Parameter.getEqInstance((Object)e.getSourceId()));
                    param.getParams().put("id", new Parameter("ne", (Object)e.getId()));
                    List list = this.executePlanDetailService.queryList(param, false);
                    BigDecimal executeNum = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        executeNum = list.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    detailEntity.setExecutedNum(executeNum);
                    this.allocateDetailService.saveOrUpdate((Object)detailEntity, false);
                });
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExecutePlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("employeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExecutePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecutePlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getExecutePlanDataByPlanId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExecutePlanVO>> getExecutePlanDataByPlanId(@RequestParam Long planId) {
        QueryParam param = new QueryParam();
        param.getParams().put("planId", new Parameter("eq", (Object)planId));
        List result = new ArrayList();
        List detailEntities = this.executePlanDetailService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            param = new QueryParam();
            param.getParams().put("abnormalStatus", new Parameter("eq", (Object)1));
            param.getParams().put("id", new Parameter("in", detailEntities.stream().map(ExecutePlanDetailEntity::getPid).collect(Collectors.toList())));
            List executePlanEntities = this.service.queryList(param, false);
            result = BeanMapper.mapList((Iterable)executePlanEntities, ExecutePlanVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/refExecutePlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExecutePlanVO>> refExecutePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("abnormalStatus", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExecutePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refExecutePlanDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExecutePlanDetailVO>> refExecutePlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"executeId")) {
                param.getParams().put("pid", new Parameter("eq", (Object)_con.getLong("executeId")));
            }
        } else {
            return CommonResponse.error((String)"\u5fc5\u987b\u4f20\u6267\u884c\u5355id\u53c2\u6570executeId\uff01");
        }
        IPage page = this.executePlanDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExecutePlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

