/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.YearBudgetDetailEntity;
import com.ejianc.business.procurement.plan.bean.YearBudgetEntity;
import com.ejianc.business.procurement.plan.mapper.YearBudgetMapper;
import com.ejianc.business.procurement.plan.service.IYearBudgetDetailService;
import com.ejianc.business.procurement.plan.service.IYearBudgetService;
import com.ejianc.business.procurement.plan.vo.YearBudgetDetailVO;
import com.ejianc.business.procurement.plan.vo.YearBudgetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="yearBudgetService")
public class YearBudgetServiceImpl
extends BaseServiceImpl<YearBudgetMapper, YearBudgetEntity>
implements IYearBudgetService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "YEAR_BUDGET_CODE";
    @Autowired
    private IYearBudgetDetailService detailService;

    @Override
    public YearBudgetVO insertOrUpdate(YearBudgetVO vo) {
        if (StringUtils.isBlank((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                vo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        YearBudgetEntity entity = (YearBudgetEntity)((Object)BeanMapper.map((Object)vo, YearBudgetEntity.class));
        boolean b = this.saveOrUpdateNoES((Object)entity);
        List<YearBudgetDetailEntity> detailEntityList = entity.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.detailService.saveOrUpdateBatch(detailEntityList);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public YearBudgetVO queryDetail(Long id) {
        YearBudgetEntity entity = (YearBudgetEntity)((Object)super.selectById((Serializable)id));
        YearBudgetVO vo = (YearBudgetVO)BeanMapper.map((Object)((Object)entity), YearBudgetVO.class);
        List detailList = vo.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (YearBudgetDetailVO detailVo : detailList) {
                detailVo.setTid(vo.getId().toString());
                detailVo.setTpid(detailVo.getParentId() != null && detailVo.getParentId() > 0L ? detailVo.getParentId().toString() : "");
                detailVo.setRowState("edit");
            }
            YearBudgetServiceImpl.sortIntMethod(detailList);
            vo.setYearBudgetDetailList(YearBudgetServiceImpl.createTreeData(detailList));
        }
        return vo;
    }

    private static void sortIntMethod(List<YearBudgetDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                YearBudgetDetailVO o1Detail = (YearBudgetDetailVO)objectMapper.convertValue(o1, YearBudgetDetailVO.class);
                YearBudgetDetailVO o2Detail = (YearBudgetDetailVO)objectMapper.convertValue(o2, YearBudgetDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<YearBudgetDetailVO> createTreeData(List<YearBudgetDetailVO> list) {
        ArrayList<YearBudgetDetailVO> resp = new ArrayList<YearBudgetDetailVO>();
        ArrayList<Long> rootItems = new ArrayList<Long>();
        HashMap<Long, YearBudgetDetailVO> listMap = new HashMap<Long, YearBudgetDetailVO>();
        for (YearBudgetDetailVO item : list) {
            listMap.put(item.getId(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            YearBudgetDetailVO item;
            item = list.get(i);
            Long parentId = item.getParentId();
            YearBudgetDetailVO parent = (YearBudgetDetailVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<YearBudgetDetailVO> children = new ArrayList<YearBudgetDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId());
        }
        for (Long rootId : rootItems) {
            resp.add((YearBudgetDetailVO)listMap.get(rootId));
        }
        return resp;
    }
}

