package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.perform.bean.RefundDepositDetailEntity;
/**
 * 投标保证金退还
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_refund_deposit")
public class RefundDepositEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="lot_open_date")
    private Date lotOpenDate; // 开标日期
    @TableField(value="calibration_date")
    private Date calibrationDate; // 定标日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="business_type")
    private String businessType; // 标的物类别1-工程，2-货物，3-服务
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="purchase_project_code")
    private String purchaseProjectCode; // 采购项目名称
    @TableField(value="lot")
    private String lot; // 标段
    @TableField(value="lot_code")
    private String lotCode; // 标书编号
    @TableField(value="lot_num")
    private Integer lotNum; // 标段数量
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="purchase_project_id")
    private Long purchaseProjectId; // 采购项目id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="refundDepositDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<RefundDepositDetailEntity> refundDepositDetailList = new ArrayList<>(); // 投标保证金退还表明细
    

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public Date getLotOpenDate() {
        return lotOpenDate;
    }

    public void setLotOpenDate(Date lotOpenDate) {
        this.lotOpenDate = lotOpenDate;
    }
    public Date getCalibrationDate() {
        return calibrationDate;
    }

    public void setCalibrationDate(Date calibrationDate) {
        this.calibrationDate = calibrationDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public String getLot() {
        return lot;
    }

    public void setLot(String lot) {
        this.lot = lot;
    }
    public String getLotCode() {
        return lotCode;
    }

    public void setLotCode(String lotCode) {
        this.lotCode = lotCode;
    }
    public Integer getLotNum() {
        return lotNum;
    }

    public void setLotNum(Integer lotNum) {
        this.lotNum = lotNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }

    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    
    public List<RefundDepositDetailEntity> getRefundDepositDetailList() {
        return refundDepositDetailList;
    }

    public void setRefundDepositDetailList(List<RefundDepositDetailEntity> refundDepositDetailList) {
        this.refundDepositDetailList = refundDepositDetailList;
    }
}
