/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.DemandPlanEntity;
import com.ejianc.business.procurement.plan.service.IDemandPlanService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="demandPlan")
public class DemandPlanBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IDemandPlanService service;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DemandPlanEntity entity = (DemandPlanEntity)((Object)this.service.getById(billId));
        String billCode = entity.getBillCode();
        String businessType = entity.getBusinessType();
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb========= id = " + entity.getId() + "\uff0cbillCode = " + billCode);
        Long noticeId = entity.getNoticeId();
        String employeeName = entity.getEmployeeName();
        if (noticeId != null) {
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            String[] receivers = String.valueOf(noticeId).split(",");
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            String urlRoute = "demandPlanGoods";
            String name = "\u8d27\u7269";
            if ("1".equals(businessType)) {
                urlRoute = "demandPlanProject";
                name = "\u5de5\u7a0b";
            } else if ("3".equals(businessType)) {
                urlRoute = "demandPlanService";
                name = "\u670d\u52a1";
            }
            String url = this.baseHost + "ejc-procurement-frontend/#/" + urlRoute + "/card?id=" + billId;
            parameter.setPcUrl(url);
            parameter.setMobileUrl(this.baseHost + "ejc-procurement-mobile/#/" + urlRoute + "/card?id=" + billId);
            parameter.setSubject(employeeName + "\u63d0\u4ea4\u7684\u3010\u9700\u6c42\u8ba1\u5212(" + name + ")\u2014\u2014\u5355\u636e\u7f16\u53f7:" + billCode + "\u3011\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u77e5\u6653\uff01");
            String sysContent = parameter.getSubject() + "<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
            parameter.setContent(sysContent);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

