package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.perform.bean.ExpertExtractionSuperviseEntity;
import com.ejianc.business.procurement.perform.bean.ExpertExtractionMemberEntity;
/**
 * 专家抽取记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_expert_extraction")
public class ExpertExtractionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="recommend_way")
    private String recommendWay; // 推荐方式
    @TableField(value="other_type")
    private String otherType; // 其他类型
    @TableField(value="expert_type_name")
    private String expertTypeName; // 所需专家类别
    @TableField(value="expert_type_id")
    private Long expertTypeId; // 所需专家类别
    @TableField(value="extract_num")
    private Integer extractNum; // 抽取人数
    @TableField(value="appoint_num")
    private Integer appointNum; // 专家中指定人数
    @TableField(value="expert_num")
    private Integer expertNum; // 专家人数
    @TableField(value="invite_num")
    private Integer inviteNum; // 采购方代表人数
    @TableField(value="jury_num")
    private Integer juryNum; // 评标委员会
    @TableField(value="need_time")
    private Integer needTime; // 评标所需时间
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="purchase_project_code")
    private String purchaseProjectCode; // 采购项目编号
    @TableField(value="purchase_project_id")
    private Long purchaseProjectId; // 采购项目
    @TableField(value="place")
    private String place; // 评标地点
    @TableField(value="expert_date")
    private Date expertDate; // 专家选取日期
    @TableField(value="start_date")
    private Date startDate; // 评标开始时间
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 采购预算
    @TableField(value="invite_tender_code")
    private String inviteTenderCode; // 拟邀请事项申报表编码
    @TableField(value="invite_tender_id")
    private Long inviteTenderId; // 拟邀请事项申报表
    @TableField(value="publish_type")
    private Integer publishType; // 采购公开程度：公开、邀请
    @TableField(value="process_type")
    private Integer processType; // 流程类型1平台全流程2平台半流程3全线下
    @TableField(value="bidding_program")
    private Integer biddingProgram; // 招标执行程序：1-法定必招项目；2-一般必招项目
    @TableField(value="purchase_deploy_place")
    private Integer purchaseDeployPlace; // 采购实施地点：1-境内；2-境外
    @TableField(value="plan_object")
    private String planObject; // 采购标的
    @TableField(value="purchase_project_name")
    private String purchaseProjectName; // 采购项目名称
    @TableField(value="purchase_type")
    private String purchaseType; // 采购方式：1-带量；2-入围；3-框架
    @TableField(value="execute_plan_name")
    private String executePlanName; // 执行计划名称
    @TableField(value="execute_plan_code")
    private String executePlanCode; // 执行计划编码
    @TableField(value="execute_plan_id")
    private Long executePlanId; // 执行计划
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="organize_shape")
    private Integer organizeShape; // 采购组织形式1-自主采购,2-委托采购
    @TableField(value="permission_type")
    private Integer permissionType; // 实施权限1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    @TableField(value="perform_way")
    private String performWay; // 采购实施方式1-招标，2-非招标
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="bill_code")
    private String billCode; // 采购项目编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="expertExtractionSuperviseService")//此处有pid="xxx"，默认值pid="pid"
    private List<ExpertExtractionSuperviseEntity> superviseList = new ArrayList<>(); // 专家抽取记录-监督记录情况表
    @TableField(exist=false)
    @SubEntity(serviceName="expertExtractionMemberService")//此处有pid="xxx"，默认值pid="pid"
    private List<ExpertExtractionMemberEntity> memberList = new ArrayList<>(); // 专家抽取记录-评标委员会情况

    public Integer getJuryNum() {
        return juryNum;
    }

    public void setJuryNum(Integer juryNum) {
        this.juryNum = juryNum;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRecommendWay() {
        return recommendWay;
    }

    public void setRecommendWay(String recommendWay) {
        this.recommendWay = recommendWay;
    }
    public String getOtherType() {
        return otherType;
    }

    public void setOtherType(String otherType) {
        this.otherType = otherType;
    }
    public String getExpertTypeName() {
        return expertTypeName;
    }

    public void setExpertTypeName(String expertTypeName) {
        this.expertTypeName = expertTypeName;
    }
    public Long getExpertTypeId() {
        return expertTypeId;
    }

    public void setExpertTypeId(Long expertTypeId) {
        this.expertTypeId = expertTypeId;
    }
    public Integer getExtractNum() {
        return extractNum;
    }

    public void setExtractNum(Integer extractNum) {
        this.extractNum = extractNum;
    }
    public Integer getAppointNum() {
        return appointNum;
    }

    public void setAppointNum(Integer appointNum) {
        this.appointNum = appointNum;
    }
    public Integer getExpertNum() {
        return expertNum;
    }

    public void setExpertNum(Integer expertNum) {
        this.expertNum = expertNum;
    }
    public Integer getInviteNum() {
        return inviteNum;
    }

    public void setInviteNum(Integer inviteNum) {
        this.inviteNum = inviteNum;
    }
    public Integer getNeedTime() {
        return needTime;
    }

    public void setNeedTime(Integer needTime) {
        this.needTime = needTime;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }

    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }
    public Date getExpertDate() {
        return expertDate;
    }

    public void setExpertDate(Date expertDate) {
        this.expertDate = expertDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public String getInviteTenderCode() {
        return inviteTenderCode;
    }

    public void setInviteTenderCode(String inviteTenderCode) {
        this.inviteTenderCode = inviteTenderCode;
    }
    public Long getInviteTenderId() {
        return inviteTenderId;
    }

    public void setInviteTenderId(Long inviteTenderId) {
        this.inviteTenderId = inviteTenderId;
    }
    public Integer getPublishType() {
        return publishType;
    }

    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }
    public Integer getProcessType() {
        return processType;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }
    public Integer getBiddingProgram() {
        return biddingProgram;
    }

    public void setBiddingProgram(Integer biddingProgram) {
        this.biddingProgram = biddingProgram;
    }
    public Integer getPurchaseDeployPlace() {
        return purchaseDeployPlace;
    }

    public void setPurchaseDeployPlace(Integer purchaseDeployPlace) {
        this.purchaseDeployPlace = purchaseDeployPlace;
    }
    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }
    public String getPurchaseProjectName() {
        return purchaseProjectName;
    }

    public void setPurchaseProjectName(String purchaseProjectName) {
        this.purchaseProjectName = purchaseProjectName;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getExecutePlanName() {
        return executePlanName;
    }

    public void setExecutePlanName(String executePlanName) {
        this.executePlanName = executePlanName;
    }
    public String getExecutePlanCode() {
        return executePlanCode;
    }

    public void setExecutePlanCode(String executePlanCode) {
        this.executePlanCode = executePlanCode;
    }
    public Long getExecutePlanId() {
        return executePlanId;
    }

    public void setExecutePlanId(Long executePlanId) {
        this.executePlanId = executePlanId;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public Integer getOrganizeShape() {
        return organizeShape;
    }

    public void setOrganizeShape(Integer organizeShape) {
        this.organizeShape = organizeShape;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public String getPerformWay() {
        return performWay;
    }

    public void setPerformWay(String performWay) {
        this.performWay = performWay;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<ExpertExtractionSuperviseEntity> getSuperviseList() {
        return superviseList;
    }

    public void setSuperviseList(List<ExpertExtractionSuperviseEntity> superviseList) {
        this.superviseList = superviseList;
    }

    public List<ExpertExtractionMemberEntity> getMemberList() {
        return memberList;
    }

    public void setMemberList(List<ExpertExtractionMemberEntity> memberList) {
        this.memberList = memberList;
    }
}
