package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.consts.BusinessTypeEnum;
import com.ejianc.business.procurement.perform.bean.*;
import com.ejianc.business.procurement.perform.consts.BusinessStateEnum;
import com.ejianc.business.procurement.perform.consts.NobidMethodEnum;
import com.ejianc.business.procurement.perform.service.*;
import com.ejianc.business.procurement.perform.vo.*;
import com.ejianc.business.procurement.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购项目
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseProject")
public class PurchaseProjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPurchaseProjectService service;

    @Autowired
    private IPurchaseProjectDetailService detailService;

    @Autowired
    private IPurchaseProjectSupplierService supplierService;

    @Autowired
    private IPurchaseProjectConfirmService confirmService;

    @Autowired
    private IPurchaseProjectAnswerService answerService;

    @Autowired
    private SessionManager sessionManager;

    private static Map<String, String> codeRuleMap = new HashMap<>();

    static {
        codeRuleMap.put(BusinessTypeEnum.HUO_WU.getCode(), "PURCHASE_PROJECT_CODE");
        codeRuleMap.put(BusinessTypeEnum.GONG_CHENG.getCode(), "PURCHASE_PROJECT_GC_CODE");
        codeRuleMap.put(BusinessTypeEnum.FU_WU.getCode(), "PURCHASE_PROJECT_FW_CODE");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseProjectVO> saveOrUpdate(@RequestBody PurchaseProjectVO saveOrUpdateVO) {
        LambdaQueryWrapper<PurchaseProjectEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PurchaseProjectEntity::getExecutePlanId, saveOrUpdateVO.getExecutePlanId());
        wrapper.ne(saveOrUpdateVO.getId() != null, PurchaseProjectEntity::getId, saveOrUpdateVO.getId());
        wrapper.ne(PurchaseProjectEntity::getBusinessState, BusinessStateEnum.CHONG_XIN.getCode());
        if (service.count(wrapper) > 0) {
            return CommonResponse.error("该执行计划已存在一条采购项目！");
        }
        if (StringUtils.isBlank(saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(codeRuleMap.get(saveOrUpdateVO.getBusinessType()), InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdateVO.sumDetailList();
        PurchaseProjectEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseProjectEntity.class);
        if (entity.getId() == null) {
            entity.setExpertFlag(0);
            entity.setDirectFlag(0);
        }
        entity.setBusinessState(Optional.ofNullable(entity.getBusinessState()).orElse(BusinessStateEnum.ZHENG_CHANG.getCode()));
        service.saveOrUpdate(entity, false);
        List<PurchaseProjectConfirmEntity> confirmList = entity.getConfirmList();
        if (CollectionUtils.isNotEmpty(confirmList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (PurchaseProjectConfirmEntity cdEntity : confirmList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PurchaseProjectConfirmEntity cdEntity : confirmList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            confirmService.saveOrUpdateBatch(confirmList);
        }
        List<PurchaseProjectAnswerEntity> answerList = entity.getAnswerList();
        if (CollectionUtils.isNotEmpty(answerList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (PurchaseProjectAnswerEntity cdEntity : answerList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PurchaseProjectAnswerEntity cdEntity : answerList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            answerService.saveOrUpdateBatch(answerList);
        }
        return CommonResponse.success("保存或修改单据成功！", service.queryDetailById(entity.getId()));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseProjectVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetailById(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchaseProjectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchaseProjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<PurchaseProjectEntity> page = service.queryPage(param, false);
        IPage<PurchaseProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseProjectVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @description: queryExist
     *
     * @return {@link CommonResponse< String>}
     * @author songlx
     * @date: 2025/12/10
     */
    @RequestMapping(value = "/queryExist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> queryExist(@RequestBody ExpertExtractionVO saveOrUpdateVO) {
        LambdaQueryWrapper<PurchaseProjectEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PurchaseProjectEntity::getExecutePlanId, saveOrUpdateVO.getExecutePlanId());
        wrapper.ne(saveOrUpdateVO.getId() != null, PurchaseProjectEntity::getId, saveOrUpdateVO.getId());
        wrapper.ne(PurchaseProjectEntity::getBusinessState, BusinessStateEnum.CHONG_XIN.getCode());
        if (service.count(wrapper) > 0) {
            return CommonResponse.error("该执行计划已存在一条采购项目！");
        }
        return CommonResponse.success();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseProjectEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<PurchaseProjectVO> voList = BeanMapper.mapList(list, PurchaseProjectVO.class);
        for (PurchaseProjectVO vo : voList) {
            Integer permissionType = vo.getPermissionType();
            if (permissionType != null) {
                if (permissionType.intValue() == 1) {
                    vo.setPermissionTypeName("一级集采");
                } else if (permissionType.intValue() == 2) {
                    vo.setPermissionTypeName("二级集采");
                } else if (permissionType.intValue() == 3) {
                    vo.setPermissionTypeName("所属单位");
                } else if (permissionType.intValue() == 4) {
                    vo.setPermissionTypeName("项目经理部");
                }
            }
            Integer processType = vo.getProcessType();
            if (processType.intValue() == 1) {
                vo.setProcessTypeName("平台全流程");
            } else if (processType.intValue() == 2) {
                vo.setProcessTypeName("平台半流程");
            } else if (processType.intValue() == 3) {
                vo.setProcessTypeName("全线下");
            }
            Integer nobidMethod = vo.getNobidMethod();
            if (nobidMethod != null) {
                vo.setNobidMethodName(NobidMethodEnum.getNameByCode(nobidMethod));
            }
            Integer businessState = vo.getBusinessState();
            if (businessState != null) {
                vo.setBusinessStateName(BusinessStateEnum.getNameByCode(businessState));
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("PurchaseProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectVO>> refPurchaseProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("businessState", new Parameter(QueryParam.EQ, BusinessStateEnum.ZHENG_CHANG.getCode()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // BusinessTypeEnum
            if (_con.containsKey("businessType")) {
                param.getParams().put("businessType", new Parameter(QueryParam.EQ, _con.get("businessType")));
            }
            // BusinessStateEnum 业务状态 1-正常，2-取消采购，3-暂停采购，4-重新采购
            if (_con.containsKey("businessState")) {
                param.getParams().put("businessState", new Parameter(QueryParam.IN, _con.get("businessState")));
            }
            if (_con.containsKey("expertFlag")) {
                param.getParams().put("expertFlag", new Parameter(QueryParam.EQ, _con.get("expertFlag")));
            }
            if (_con.containsKey("directFlag")) {
                param.getParams().put("directFlag", new Parameter(QueryParam.EQ, _con.get("directFlag")));
            }
            if (_con.containsKey("orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            // 采购实施方式1-招标，2-非招标
            if (_con.containsKey("performWay")) {
                param.getParams().put("performWay", new Parameter(QueryParam.EQ, _con.get("performWay")));
            }
        }
        IPage<PurchaseProjectEntity> page = service.queryPage(param, false);
        IPage<PurchaseProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseProjectVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseProjectDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectDetailVO>> refPurchaseProjectDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                       String condition,
                                                                                       @RequestParam(required = false) String relyCondition,
                                                                                       String searchObject,
                                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(relyCondition)) {
            Long planId = Long.valueOf(relyCondition.split("=")[1]);
            param.getParams().put("pid", new Parameter(QueryParam.EQ, planId));
        } else {
            throw new BusinessException("请选择采购项目！");
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchaseProjectDetailEntity> page = detailService.queryPage(param, false);
        IPage<PurchaseProjectDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseProjectDetailVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseProjectSupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectSupplierVO>> refPurchaseProjectSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                           String condition,
                                                                                           @RequestParam(required = false) String relyCondition,
                                                                                           String searchObject,
                                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(relyCondition)) {
            Long planId = Long.valueOf(relyCondition.split("=")[1]);
            param.getParams().put("pid", new Parameter(QueryParam.EQ, planId));
        } else {
            throw new BusinessException("请选择采购项目！");
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchaseProjectSupplierEntity> page = supplierService.queryPage(param, false);
        IPage<PurchaseProjectSupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseProjectSupplierVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


}
