package com.ejianc.business.procurement.perform.service.impl;

import com.ejianc.business.procurement.perform.vo.PurchaseProjectAnswerVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectConfirmVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectVO;
import com.ejianc.business.procurement.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procurement.perform.mapper.PurchaseProjectMapper;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;

import java.util.List;

/**
 * 采购项目
 * 
 * @author generator
 * 
 */
@Service("purchaseProjectService")
public class PurchaseProjectServiceImpl extends BaseServiceImpl<PurchaseProjectMapper, PurchaseProjectEntity> implements IPurchaseProjectService{

    @Override
    public PurchaseProjectVO queryDetailById(Long id) {
        PurchaseProjectEntity entity = this.selectById(id);
        PurchaseProjectVO vo = BeanMapper.map(entity, PurchaseProjectVO.class);
        vo.splitDetailList();
        List<PurchaseProjectConfirmVO> confirmList = vo.getConfirmList();
        if (CollectionUtils.isNotEmpty(confirmList)) {
            for (PurchaseProjectConfirmVO cdEntity : confirmList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
            vo.setConfirmList(TreeNodeBUtil.buildTree(confirmList));
        }
        List<PurchaseProjectAnswerVO> answerList = vo.getAnswerList();
        if (CollectionUtils.isNotEmpty(answerList)) {
            for (PurchaseProjectAnswerVO cdEntity : answerList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
            vo.setAnswerList(TreeNodeBUtil.buildTree(answerList));
        }
        return vo;
    }
}
