package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁合同记录
 * 
 * @author generator
 * 
 */
public class RentContractRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 合同名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Integer rentType; // 租赁方式
    private String rentTypeName; // 租赁方式名称
    private Long calibrationResultId; // 定标结果id
    private String calibrationResultName; // 定标结果名称
    private String contractCode; // 合同编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private String projectCode; // 项目编号
    private Long companyId; // 所属单位
    private String companyName; // 所属单位名称
    private Long contractType; // 合同类别
    private String contractTypeName; // 合同类别名称
    private Long partyId; // 甲方
    private String partyName; // 甲方名称
    private Long partyUser; // 甲方负责人
    private String partyUserName; // 甲方负责人名称
    private Long partyHandleUser; // 甲方经办人
    private String partyHandleUserName; // 甲方经办人名称
    private Long partyPhone; // 甲方电话
    private Long supplierId; // 乙方id
    private String supplierName; // 乙方名称
    private Long supplierHandleUser; // 乙方经办人id
    private String supplierHandleUserName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    private String supplierAddress; // 乙方地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signedDate; // 签订日期
    private String meterRentType; // 计租方式 day

    private String meterRentTypeName; // 计租方式名称
    private String monthSettlement; // 月结算日
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date meterDate; // 计租日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date preventDate; // 止租时间
    private String supplyPlace; // 供货地点
    private BigDecimal contractTax; // 合同税率
    private String contractPerformanceState; // 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；   默认为未签定
    private String contractPerformanceName; // 合同履约状态名称
    private String draftType; // 起草方式:1--线上起草,2-----合同上传，3---线下
    private String draftTypeName; // 起草方式名称
    private String contractFile; // 合同附件
    private Long contractFileId; // 合同附件id
    private String memo; // 备注
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractAmountTax; // 合同税额
    private Integer contractState; // 合同状态:1--未签订,2--履约中,3-已终止,4-已作废,5-已冻结,6-已结束,
    private String signatureState; // 1---未签章,2---待乙方签章,3-待甲方签章,4-已签章
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal afterChangeMny; // 变更后金额
    private BigDecimal beforeChangeTaxMny; // 变更前金额(含税)
    private String changingItem; // 变更项
    private BigDecimal changingRatio; // 变更比例
    private BigDecimal changingTax; // 本次变更税额
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private String changeFile; // 变更附件
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeDraftType; // 变更起草类型
    private Integer addType; // 1----直接添加----2---定标结果
    private Long mainContractId; // 主合同
    private String mainContractCode; // 主合同编码
    private String mainContractName; // 主合同名称
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private String supplementDescribe; // 补充协议补充项描述
    private String supplementCode; // 补充协议编号
    private String supplementName; // 补充协议名称
    private Integer supplementState; // 补充协议状态:1-未签订,2-履约中,3-已终止,4-已作废
    private String supplementFile; // 协议附件
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 生效时间
    private Integer changeContractSignatureStatus; // 变更是否签章
    private BigDecimal changingMny; // 变更中金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private String contractName; // 合同名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期
    private BigDecimal baseMny; // 初始版本金额
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    private Long contractId; // 合同id

    private Long supplementHandleUser; // 补充协议经办人
    private String supplementHandleUserName; // 补充协议经办人名称
    private Long targetResultId;
    private String targetResultName;
    private Boolean targetType;
    private Integer rentHarborType;//租赁港式
    private Long signedFileId; // 签章完成合同文件Id
    private Long orgId; // orgId
    private String orgName;
    private Long parentOrgId;
    private String parentOrgName;
    private String parentOrgCode;

    private List<RentDayRecordVO> rentDayDetailedList = new ArrayList<>(); // 租赁日租明细

    private List<RentMonthRecordVO> rentMonthDetailedList = new ArrayList<>(); // 租赁月租明细

    private List<RentQuantitiesRecordVO> rentQuantitiesDetailedList = new ArrayList<>(); // 租赁工程量明细

    private List<RentOtherRecordVO> rentOtherDetailedList = new ArrayList<>(); // 租赁其它费用明细

    private List<RentClauseRecordVO> rentContractClauseList = new ArrayList<>(); // 租赁合同条款

    private List<RentContractPaymentRecordVO> rentContractPaymentClauseList = new ArrayList<>(); // 租赁合同支付条款
    @TableField(value="org_code")
    private String orgCode;
    @TableField("change_filing_status")
    private Integer changeFilingStatus;//是否归档 1：是；0：否
    @TableField("filing_ref")
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否
    @TableField("filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否
    @TableField(value="purchase_type")
    private Integer purchaseType;//采购方式(0-项目采购,1-单位采购)
    @TableField(value="target_tax_mny")
    private BigDecimal targetTaxMny;//采购方式(0-项目采购,1-单位采购)

    public BigDecimal getTargetTaxMny() {
        return targetTaxMny;
    }

    public void setTargetTaxMny(BigDecimal targetTaxMny) {
        this.targetTaxMny = targetTaxMny;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public Integer getChangeFilingStatus() {
        return changeFilingStatus;
    }

    public void setChangeFilingStatus(Integer changeFilingStatus) {
        this.changeFilingStatus = changeFilingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }
    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    public Long getCalibrationResultId() {
        return calibrationResultId;
    }

    public void setCalibrationResultId(Long calibrationResultId) {
        this.calibrationResultId = calibrationResultId;
    }
    public String getCalibrationResultName() {
        return calibrationResultName;
    }

    public void setCalibrationResultName(String calibrationResultName) {
        this.calibrationResultName = calibrationResultName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getPartyId() {
        return partyId;
    }
    @ReferDeserialTransfer
    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }
    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getPartyUser() {
        return partyUser;
    }
    @ReferDeserialTransfer
    public void setPartyUser(Long partyUser) {
        this.partyUser = partyUser;
    }
    public String getPartyUserName() {
        return partyUserName;
    }

    public void setPartyUserName(String partyUserName) {
        this.partyUserName = partyUserName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getPartyHandleUser() {
        return partyHandleUser;
    }
    @ReferDeserialTransfer
    public void setPartyHandleUser(Long partyHandleUser) {
        this.partyHandleUser = partyHandleUser;
    }
    public String getPartyHandleUserName() {
        return partyHandleUserName;
    }

    public void setPartyHandleUserName(String partyHandleUserName) {
        this.partyHandleUserName = partyHandleUserName;
    }
    public Long getPartyPhone() {
        return partyPhone;
    }

    public void setPartyPhone(Long partyPhone) {
        this.partyPhone = partyPhone;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getSupplierHandleUser() {
        return supplierHandleUser;
    }
    @ReferDeserialTransfer
    public void setSupplierHandleUser(Long supplierHandleUser) {
        this.supplierHandleUser = supplierHandleUser;
    }
    public String getSupplierHandleUserName() {
        return supplierHandleUserName;
    }

    public void setSupplierHandleUserName(String supplierHandleUserName) {
        this.supplierHandleUserName = supplierHandleUserName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }
    public Date getSignedDate() {
        return signedDate;
    }

    public void setSignedDate(Date signedDate) {
        this.signedDate = signedDate;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMeterRentType() {
        return meterRentType;
    }
    @ReferDeserialTransfer
    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }
    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }
    public String getMonthSettlement() {
        return monthSettlement;
    }

    public void setMonthSettlement(String monthSettlement) {
        this.monthSettlement = monthSettlement;
    }
    public Date getMeterDate() {
        return meterDate;
    }

    public void setMeterDate(Date meterDate) {
        this.meterDate = meterDate;
    }
    public Date getPreventDate() {
        return preventDate;
    }

    public void setPreventDate(Date preventDate) {
        this.preventDate = preventDate;
    }
    public String getSupplyPlace() {
        return supplyPlace;
    }

    public void setSupplyPlace(String supplyPlace) {
        this.supplyPlace = supplyPlace;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public String getContractPerformanceState() {
        return contractPerformanceState;
    }

    public void setContractPerformanceState(String contractPerformanceState) {
        this.contractPerformanceState = contractPerformanceState;
    }
    public String getContractPerformanceName() {
        return contractPerformanceName;
    }

    public void setContractPerformanceName(String contractPerformanceName) {
        this.contractPerformanceName = contractPerformanceName;
    }
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    public String getDraftTypeName() {
        return draftTypeName;
    }

    public void setDraftTypeName(String draftTypeName) {
        this.draftTypeName = draftTypeName;
    }
    public String getContractFile() {
        return contractFile;
    }

    public void setContractFile(String contractFile) {
        this.contractFile = contractFile;
    }
    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAmountTax() {
        return contractAmountTax;
    }

    public void setContractAmountTax(BigDecimal contractAmountTax) {
        this.contractAmountTax = contractAmountTax;
    }
    public Integer getContractState() {
        return contractState;
    }

    public void setContractState(Integer contractState) {
        this.contractState = contractState;
    }
    public String getSignatureState() {
        return signatureState;
    }

    public void setSignatureState(String signatureState) {
        this.signatureState = signatureState;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getAfterChangeMny() {
        return afterChangeMny;
    }

    public void setAfterChangeMny(BigDecimal afterChangeMny) {
        this.afterChangeMny = afterChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public String getChangingItem() {
        return changingItem;
    }

    public void setChangingItem(String changingItem) {
        this.changingItem = changingItem;
    }
    public BigDecimal getChangingRatio() {
        return changingRatio;
    }

    public void setChangingRatio(BigDecimal changingRatio) {
        this.changingRatio = changingRatio;
    }
    public BigDecimal getChangingTax() {
        return changingTax;
    }

    public void setChangingTax(BigDecimal changingTax) {
        this.changingTax = changingTax;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeFile() {
        return changeFile;
    }

    public void setChangeFile(String changeFile) {
        this.changeFile = changeFile;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public String getSupplementCode() {
        return supplementCode;
    }

    public void setSupplementCode(String supplementCode) {
        this.supplementCode = supplementCode;
    }
    public String getSupplementName() {
        return supplementName;
    }

    public void setSupplementName(String supplementName) {
        this.supplementName = supplementName;
    }
    public Integer getSupplementState() {
        return supplementState;
    }

    public void setSupplementState(Integer supplementState) {
        this.supplementState = supplementState;
    }
    public String getSupplementFile() {
        return supplementFile;
    }

    public void setSupplementFile(String supplementFile) {
        this.supplementFile = supplementFile;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public List<RentDayRecordVO> getRentDayDetailedList() {
        return rentDayDetailedList;
    }

    public void setRentDayDetailedList(List<RentDayRecordVO> rentDayDetailedList) {
        this.rentDayDetailedList = rentDayDetailedList;
    }

    public List<RentMonthRecordVO> getRentMonthDetailedList() {
        return rentMonthDetailedList;
    }

    public void setRentMonthDetailedList(List<RentMonthRecordVO> rentMonthDetailedList) {
        this.rentMonthDetailedList = rentMonthDetailedList;
    }

    public List<RentQuantitiesRecordVO> getRentQuantitiesDetailedList() {
        return rentQuantitiesDetailedList;
    }

    public void setRentQuantitiesDetailedList(List<RentQuantitiesRecordVO> rentQuantitiesDetailedList) {
        this.rentQuantitiesDetailedList = rentQuantitiesDetailedList;
    }

    public List<RentOtherRecordVO> getRentOtherDetailedList() {
        return rentOtherDetailedList;
    }

    public void setRentOtherDetailedList(List<RentOtherRecordVO> rentOtherDetailedList) {
        this.rentOtherDetailedList = rentOtherDetailedList;
    }

    public List<RentClauseRecordVO> getRentContractClauseList() {
        return rentContractClauseList;
    }

    public void setRentContractClauseList(List<RentClauseRecordVO> rentContractClauseList) {
        this.rentContractClauseList = rentContractClauseList;
    }

    public List<RentContractPaymentRecordVO> getRentContractPaymentClauseList() {
        return rentContractPaymentClauseList;
    }

    public void setRentContractPaymentClauseList(List<RentContractPaymentRecordVO> rentContractPaymentClauseList) {
        this.rentContractPaymentClauseList = rentContractPaymentClauseList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getSupplementHandleUser() {
        return supplementHandleUser;
    }

    public void setSupplementHandleUser(Long supplementHandleUser) {
        this.supplementHandleUser = supplementHandleUser;
    }

    public String getSupplementHandleUserName() {
        return supplementHandleUserName;
    }

    public void setSupplementHandleUserName(String supplementHandleUserName) {
        this.supplementHandleUserName = supplementHandleUserName;
    }
    @ReferSerialTransfer(referCode="refRentsupplierData")
    public Long getTargetResultId() {
        return targetResultId;
    }
    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public Boolean getTargetType() {
        return targetType;
    }

    public void setTargetType(Boolean targetType) {
        this.targetType = targetType;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
