package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 租赁设备台账明细
 * 
 * @author generator
 * 
 */
@ApiModel("租赁设备台账明细")
public class RentParameterDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键")
    private Long parameterId;
    @ApiModelProperty("操作日期（启用/停用/租金计算日期）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date operationDate;
    @ApiModelProperty("设备状态:1--进场,2--启用,3--停用,4--退场")
    private Integer equipmentState;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("来源类型（0-启用单，1-停用单，2-租金计算，3-退场）")
    private String sourceType;


    public Long getParameterId() {
        return parameterId;
    }

    public void setParameterId(Long parameterId) {
        this.parameterId = parameterId;
    }

    /**
     * 操作日期（启用/停用/租金计算日期）
     */
    public Date getOperationDate() {
        return operationDate;
    }

    /**
     * 操作日期（启用/停用/租金计算日期）
     */
    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }
    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    public Integer getEquipmentState() {
        return equipmentState;
    }

    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }
    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源类型（0-启用单，1-停用单，2-租金计算，3-退场）
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型（0-启用单，1-停用单，2-租金计算，3-退场）
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    
}
