package com.ejianc.business.order.enums;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OutRentReceiptsEnum {
    验收单("验收单", "BT220210000000022","supplierSignImg","租出验收单"),
    //项目方启用单
    启用单("启用单", "BT220221000000003","supplierSign","租出启用单"),
    //项目方停用单
    停用单("停用单", "BT220221000000004","supplierSign","租出停用单"),
    //项目方退场单
    退场单("退场单", "BT220302000000006","supplierSign","租出退场单"),
    //项目方结算单
    结算单("结算单", "EJCBT202204000006","supplierSign","租出结算单");


    private final String name;
    private final String code;
    private final String fileType;
    private final String sourceName;
    private static Map<String, OutRentReceiptsEnum> enumMap;
    private static Map<String, OutRentReceiptsEnum> enumMap1;

    private OutRentReceiptsEnum(String name, String code, String fileType, String sourceName) {
        this.name = name;
        this.code = code;
        this.fileType = fileType;
        this.sourceName = sourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getFileType() {
        return fileType;
    }

    public String getSourceName() {
        return sourceName;
    }

    public static OutRentReceiptsEnum getEnumByName(String billTypeName) {
        return enumMap.get(billTypeName);
    }

    public static OutRentReceiptsEnum getEnumBySourceName(String billTypeName) {
        return enumMap1.get(billTypeName);
    }

    static {
        enumMap = EnumSet.allOf(OutRentReceiptsEnum.class).stream().collect(Collectors.toMap(OutRentReceiptsEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
        enumMap1  = EnumSet.allOf(OutRentReceiptsEnum.class).stream().collect(Collectors.toMap(OutRentReceiptsEnum::getSourceName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
