package com.ejianc.business.order.enums;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RentReceiptsEnum {
    //周转材租赁订单
    租赁订单("租赁订单", "BT220209000000007","supplierSignImg",""),
    //周转材验收单
    验收单("验收单", "BT220210000000022","supplierSignImg","租出验收单"),
    //周转材启用单
    启用单("启用单", "BT220209000000008","supplierSignImg","租出启用单"),
    //周转材停用单
    停用单("停用单", "BT220209000000009","supplierSignImg","租出停用单"),
    //周转材退赔单

    //结算单
    租赁合同结算单("租赁合同结算单", "BT220310000000002","supplierSignImg","租赁合同结算单"),
    退场单("退场单", "BT220302000000006","supplierSignImg1","退场单"),
    租金计算单("租金计算单", "BT220312000000001","supplierSignImg1","租金计算单");

    private final String name;
    private final String code;
    private final String fileType;
    private final String sourceName;
    private static Map<String, RentReceiptsEnum> enumMap;
    private static Map<String, RentReceiptsEnum> enumMap1;

    private RentReceiptsEnum(String name, String code, String fileType, String sourceName) {
        this.name = name;
        this.code = code;
        this.fileType = fileType;
        this.sourceName = sourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getFileType() {
        return fileType;
    }

    public String getSourceName() {
        return sourceName;
    }

    public static RentReceiptsEnum getEnumByName(String billTypeName) {
        return enumMap.get(billTypeName);
    }

    public static RentReceiptsEnum getEnumBySourceName(String billTypeName) {
        return enumMap1.get(billTypeName);
    }

    static {
        enumMap = EnumSet.allOf(RentReceiptsEnum.class).stream().collect(Collectors.toMap(RentReceiptsEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
        enumMap1  = EnumSet.allOf(RentReceiptsEnum.class).stream().collect(Collectors.toMap(RentReceiptsEnum::getSourceName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
