package com.ejianc.business.rentdelivery.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 消耗材-发货单子表
 *
 * @author generator
 *
 */
@ApiModel("设备租赁验收-发货单子表")
public class RentDeliveryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源发货主表id")
    private Long sourceId;
    @ApiModelProperty("来源发货子表id")
    private Long sourceDetailId;
    @ApiModelProperty("发货主键ID")
    private Long deliveryId;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("订单明细主键ID")
    private Long orderDetailId;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("单位名称")
    private String unit;
    @ApiModelProperty("单位主键")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("发货数量")
    private BigDecimal deliveryNum;
    @ApiModelProperty("验收数量")
    private BigDecimal checkNum;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("备注")
    private String memo;
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 单价(含税)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_detail_id")
    private Long contractDetailId; // 合同主键
    @TableField(value="factory_code")
    private String factoryCode; // 设备出厂编号
    @TableField(value="production_manufactor")
    private String productionManufactor; // 生产厂家
    @TableField(value="rent_type")
    private Integer rentType; // 租赁方式:1--日租,2--月租,3--工程量
    @TableField(value="rent_type_name")
    private String rentTypeName; // 租赁方式:1--日租,2--月租,3--工程量
    private Long deliveryDetailId; // 发货明细主键ID(参照使用)

    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }

    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }

    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 来源发货主表id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源发货主表id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源发货子表id
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源发货子表id
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 发货主键ID
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键ID
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 订单主键ID
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单明细主键ID
     */
    public Long getOrderDetailId() {
        return orderDetailId;
    }

    /**
     * 订单明细主键ID
     */
    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 单位名称
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位名称
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 发货数量
     */
    public BigDecimal getDeliveryNum() {
        return deliveryNum;
    }

    /**
     * 发货数量
     */
    public void setDeliveryNum(BigDecimal deliveryNum) {
        this.deliveryNum = deliveryNum;
    }
    /**
     * 验收数量
     */
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    /**
     * 验收数量
     */
    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

}
