package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.rent.vo.EquipmentAdviceContentVO;

/**
 * 特种设备进场通知
 * 
 * @author generator
 * 
 */
public class EquipmentAdviceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 父组织ID
    private String parentOrgName; // 父组织名称
    private String parentOrgCode; // 父组织编码
    private String billCode; // 单据编码
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractName; // 合同名称
    private Long employeeId; // 经办人ID
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private String billStateName;
    private Long sourceId;

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
    private List<EquipmentAdviceContentVO> detailList = new ArrayList<>(); // 特种设备进场通知子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="proSubContract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<EquipmentAdviceContentVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<EquipmentAdviceContentVO> detailList) {
        this.detailList = detailList;
     }
}
