package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.rent.vo.RentAcceptanceSubVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 租赁设备验收
 *
 * @author generator
 *
 */
public class RentAcceptanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 单据编号
    private String name; // 费用项目名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billStateName; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long companyId; // 所属单位
    private String companyName; // 所属单位名称
    private Long engineeringId; // 工程id
    private String engineeringName; // 工程名称
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private String acceptanceUserName; // 验收人
    @TableField(value = "delivery_code")
    private String deliveryCode; // 发货单编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate; // 验收日期
    private String carCode; // 车票号
    private String memo; // 备注
    private Long acceptanceUserId; // 验收人id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentDate; // 计租日期
    private String acceptanceSource; // 验收来源
    private Integer acceptanceSourceId;
    private List<RentAcceptanceSubVO> rentAcceptanceSubList = new ArrayList<>(); // 租赁设备验收明细
    private Integer equipmentNum;//设备总数
    private Long projectDepartmentId; // 项目部ID
    private String projectDepartmentName; // 项目部名称
    private Boolean notSignature;//是否签字
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String supplierSignId;
    private String signArray;
    private String signArrayT;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="delivery_id")
    private Long deliveryId; // 发货主键
    @TableField(value="check_state")
    private Integer checkState; // 验收状态（0-未验收，1--已验收）
    @TableField(value="source_type")
    private Integer sourceType; // 验收来源，0-自制验收,1-发货验收
    /***  协同需要字段 START  ***/
    @TableField(value = "sign_status")
    private Integer signStatus; // 签字状态：0-未签字,1-已签字
    private String signStatusName; // 签字状态：0-未签字,1-已签字
    @TableField(value="org_code")
    private String orgCode;
    private String rentType; // 租赁方式租赁方式(0-外租，1-内租)
    private Integer entranceRentFlag; // 是否进场计租   1-是  2-否
    private String registerCode; // 使用登记号
    private Integer equipmentType; // 设备种类 1-施工升降机 2-塔式起重机
    private String equipmentTypeName; // 设备种类 1-施工升降机 2-塔式起重机
    private String installationSite; // 安装位置
    private String address; // 项目地址
    private String notifyCode; // 告知受理号
    private String recordCode; // 备案编号
    private String useUnit; // 使用单位
    private String makeUnit; // 制造单位
    private String installUnit; // 安装单位
    private String checkType; // 检验类别
    private String checkCode; // 检验报告编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检验日期
    private String checkUnit; // 检验单位
    private String signUnit; // 签发机构
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签发日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date installDate; // 安装告知日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 使用登机牌有效期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inDate; // 进场日期
    private String constructionCode; // 工地自编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 设备出厂日期
    private BigDecimal checkHeight; // 检验时高度m
    private BigDecimal loadKg; // 额定载重量kg
    private BigDecimal freeHeight; // 最大自由高度m
    private BigDecimal tgHeight; // 检验时塔机高度m
    private BigDecimal checkRange; // 检验时最大幅度m
    private BigDecimal maxRange; // 最大幅度m
    private BigDecimal maxTon; // 额最大幅度处额定起重量t
    private BigDecimal maxHeight; // 最大独立自由高度m
    private BigDecimal bracketHeight; // 附着后最大悬臂高度m
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date leaveFactoryDate; // 设备出厂日期
    private String mainFactoryCode; //设备出厂编码

    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }

    public String getMainFactoryCode() {
        return mainFactoryCode;
    }

    public void setMainFactoryCode(String mainFactoryCode) {
        this.mainFactoryCode = mainFactoryCode;
    }

    public Date getLeaveFactoryDate() {
        return leaveFactoryDate;
    }

    public void setLeaveFactoryDate(Date leaveFactoryDate) {
        this.leaveFactoryDate = leaveFactoryDate;
    }

    public String getRegisterCode() {
        return registerCode;
    }

    public void setRegisterCode(String registerCode) {
        this.registerCode = registerCode;
    }

    public Integer getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Integer equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getInstallationSite() {
        return installationSite;
    }

    public void setInstallationSite(String installationSite) {
        this.installationSite = installationSite;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getNotifyCode() {
        return notifyCode;
    }

    public void setNotifyCode(String notifyCode) {
        this.notifyCode = notifyCode;
    }

    public String getRecordCode() {
        return recordCode;
    }

    public void setRecordCode(String recordCode) {
        this.recordCode = recordCode;
    }

    public String getUseUnit() {
        return useUnit;
    }

    public void setUseUnit(String useUnit) {
        this.useUnit = useUnit;
    }



    public String getMakeUnit() {
        return makeUnit;
    }

    public void setMakeUnit(String makeUnit) {
        this.makeUnit = makeUnit;
    }

    public String getInstallUnit() {
        return installUnit;
    }

    public void setInstallUnit(String installUnit) {
        this.installUnit = installUnit;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }

    public String getSignUnit() {
        return signUnit;
    }

    public void setSignUnit(String signUnit) {
        this.signUnit = signUnit;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getInstallDate() {
        return installDate;
    }

    public void setInstallDate(Date installDate) {
        this.installDate = installDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getInDate() {
        return inDate;
    }

    public void setInDate(Date inDate) {
        this.inDate = inDate;
    }

    public String getConstructionCode() {
        return constructionCode;
    }

    public void setConstructionCode(String constructionCode) {
        this.constructionCode = constructionCode;
    }

    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    public BigDecimal getCheckHeight() {
        return checkHeight;
    }

    public void setCheckHeight(BigDecimal checkHeight) {
        this.checkHeight = checkHeight;
    }

    public BigDecimal getLoadKg() {
        return loadKg;
    }

    public void setLoadKg(BigDecimal loadKg) {
        this.loadKg = loadKg;
    }

    public BigDecimal getFreeHeight() {
        return freeHeight;
    }

    public void setFreeHeight(BigDecimal freeHeight) {
        this.freeHeight = freeHeight;
    }

    public BigDecimal getTgHeight() {
        return tgHeight;
    }

    public void setTgHeight(BigDecimal tgHeight) {
        this.tgHeight = tgHeight;
    }

    public BigDecimal getCheckRange() {
        return checkRange;
    }

    public void setCheckRange(BigDecimal checkRange) {
        this.checkRange = checkRange;
    }

    public BigDecimal getMaxRange() {
        return maxRange;
    }

    public void setMaxRange(BigDecimal maxRange) {
        this.maxRange = maxRange;
    }

    public BigDecimal getMaxTon() {
        return maxTon;
    }

    public void setMaxTon(BigDecimal maxTon) {
        this.maxTon = maxTon;
    }

    public BigDecimal getMaxHeight() {
        return maxHeight;
    }

    public void setMaxHeight(BigDecimal maxHeight) {
        this.maxHeight = maxHeight;
    }

    public BigDecimal getBracketHeight() {
        return bracketHeight;
    }

    public void setBracketHeight(BigDecimal bracketHeight) {
        this.bracketHeight = bracketHeight;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public Integer getCheckState() {
        return checkState;
    }

    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="rent-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getEngineeringId() {
        return engineeringId;
    }

    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getAcceptanceUserName() {
        return acceptanceUserName;
    }

    public void setAcceptanceUserName(String acceptanceUserName) {
        this.acceptanceUserName = acceptanceUserName;
    }
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAcceptanceUserId() {
        return acceptanceUserId;
    }
    @ReferDeserialTransfer
    public void setAcceptanceUserId(Long acceptanceUserId) {
        this.acceptanceUserId = acceptanceUserId;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }
    public String getAcceptanceSource() {
        return acceptanceSource;
    }

    public void setAcceptanceSource(String acceptanceSource) {
        this.acceptanceSource = acceptanceSource;
    }

    public List<RentAcceptanceSubVO> getRentAcceptanceSubList() {
        return rentAcceptanceSubList;
    }

    public void setRentAcceptanceSubList(List<RentAcceptanceSubVO> rentAcceptanceSubList) {
        this.rentAcceptanceSubList = rentAcceptanceSubList;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getAcceptanceSourceId() {
        return acceptanceSourceId;
    }

    public void setAcceptanceSourceId(Integer acceptanceSourceId) {
        this.acceptanceSourceId = acceptanceSourceId;
    }

    public Integer getEquipmentNum() {
        return equipmentNum;
    }

    public void setEquipmentNum(Integer equipmentNum) {
        this.equipmentNum = equipmentNum;
    }


    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }
    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getSupplierSignId() {
        return supplierSignId;
    }

    public void setSupplierSignId(String supplierSignId) {
        this.supplierSignId = supplierSignId;
    }

    public String getSignArray() {
        return signArray;
    }

    public void setSignArray(String signArray) {
        this.signArray = signArray;
    }

    public String getSignArrayT() {
        return signArrayT;
    }

    public void setSignArrayT(String signArrayT) {
        this.signArrayT = signArrayT;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public Integer getEntranceRentFlag() {
        return entranceRentFlag;
    }

    public void setEntranceRentFlag(Integer entranceRentFlag) {
        this.entranceRentFlag = entranceRentFlag;
    }
}
