package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 租赁设备台账
 * 
 * @author generator
 * 
 */
@ApiModel("租赁设备台账")
public class RentParameterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String code;
    @ApiModelProperty("设备名称")
    private String name;
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("设备出厂编号")
    private String factoryCode;
    @ApiModelProperty("设备类别id")
    private Long categoryId;
    @ApiModelProperty("设备类别名称")
    private String categoryName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unitName;
    @ApiModelProperty("租赁数量")
    private Integer rentNum;
    @ApiModelProperty("计划进程日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate;
    @ApiModelProperty("计划出场日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate;
    @ApiModelProperty("生产厂家")
    private String productionManufactor;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("设备编号")
    private String equipmentCode;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("数量/选择数量/送货数量")
    private Integer num;
    @ApiModelProperty("租赁方式id")
    private Integer rentTypeId;
    @ApiModelProperty("租赁方式名称")
    private String rentTypeName;
    @ApiModelProperty("验收单id")
    private Long acceptanceId;
    @ApiModelProperty("设备状态:1--进场,2--启用,3--停用,4--退场")
    private Integer equipmentState;
    @ApiModelProperty("设备状态:1--进场,2--启用,3--停用,4--退场")
    private String equipmentStateName;
    @ApiModelProperty("设备费用")
    private BigDecimal equipmentCost;
    @ApiModelProperty("验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate;
    @ApiModelProperty("启动日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    @ApiModelProperty("停用日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopDate;
    @ApiModelProperty("退场日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("有税单价")
    private BigDecimal price;
    @ApiModelProperty("无税单价")
    private BigDecimal notTaxPrice;
    @ApiModelProperty("验收单明细id")
    private Long acceptanceDetailId;
    @ApiModelProperty("计租日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date meterRentDate;
    @ApiModelProperty("操作日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date operationDate;
    @ApiModelProperty("工程量数量")
    private BigDecimal quantitiesNum;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("是否已计算租金（0-否，1-是）")
    private Integer settlementFlag;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("工程id")
    private Long engineeringId;
    @ApiModelProperty("工程名称")
    private String engineeringName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @TableField("rent_harbor_type")
    private Integer rentHarborType;//
    private String rentHarborTypeName;//
    private BigDecimal cumulativeWorkload;//累计工作量
    private BigDecimal contractTaxRate; // 合同税率

    private Integer equipmentType; // 设备种类 1-施工升降机 2-塔式起重机
    private String equipmentTypeName; // 设备种类 1-施工升降机 2-塔式起重机
    private String recordCode; // 备案编号

    private String makeUnit; // 制造单位
    private String installUnit; // 安装单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date leaveFactoryDate; // 设备出厂日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // (最新检测报告日期)
    private String checkResult; // 最新检测报告结论
    private String installationSite; // 安装位置
    private Integer rentMonthDate;//累计已使用时间（月）
    private String address; // 项目地址
    @ApiModelProperty("设备台账明细")
    private List<RentParameterDetailVO> rentParameterDetailList = new ArrayList<>();


    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getRentMonthDate() {
        return rentMonthDate;
    }

    public void setRentMonthDate(Integer rentMonthDate) {
        this.rentMonthDate = rentMonthDate;
    }

    public Integer getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Integer equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getRecordCode() {
        return recordCode;
    }

    public void setRecordCode(String recordCode) {
        this.recordCode = recordCode;
    }



    public String getMakeUnit() {
        return makeUnit;
    }

    public void setMakeUnit(String makeUnit) {
        this.makeUnit = makeUnit;
    }

    public String getInstallUnit() {
        return installUnit;
    }

    public void setInstallUnit(String installUnit) {
        this.installUnit = installUnit;
    }

    public Date getLeaveFactoryDate() {
        return leaveFactoryDate;
    }

    public void setLeaveFactoryDate(Date leaveFactoryDate) {
        this.leaveFactoryDate = leaveFactoryDate;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getCheckResult() {
        return checkResult;
    }

    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    public String getInstallationSite() {
        return installationSite;
    }

    public void setInstallationSite(String installationSite) {
        this.installationSite = installationSite;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public BigDecimal getCumulativeWorkload() {
        return cumulativeWorkload;
    }

    public void setCumulativeWorkload(BigDecimal cumulativeWorkload) {
        this.cumulativeWorkload = cumulativeWorkload;
    }

    public List<RentParameterDetailVO> getRentParameterDetailList() {
        return rentParameterDetailList;
    }

    public void setRentParameterDetailList(List<RentParameterDetailVO> rentParameterDetailList) {
        this.rentParameterDetailList = rentParameterDetailList;
    }

    public String getEquipmentStateName() {
        return equipmentStateName;
    }

    public void setEquipmentStateName(String equipmentStateName) {
        this.equipmentStateName = equipmentStateName;
    }

    public String getRentHarborTypeName() {
        return rentHarborTypeName;
    }

    public void setRentHarborTypeName(String rentHarborTypeName) {
        this.rentHarborTypeName = rentHarborTypeName;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 设备名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设备名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备出厂编号
     */
    public String getFactoryCode() {
        return factoryCode;
    }

    /**
     * 设备出厂编号
     */
    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }
    /**
     * 设备类别id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 设备类别id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 设备类别名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 设备类别名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 租赁数量
     */
    public Integer getRentNum() {
        return rentNum;
    }

    /**
     * 租赁数量
     */
    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    /**
     * 计划进程日期
     */
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    /**
     * 计划进程日期
     */
    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    /**
     * 计划出场日期
     */
    public Date getPlanOutDate() {
        return planOutDate;
    }

    /**
     * 计划出场日期
     */
    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    /**
     * 生产厂家
     */
    public String getProductionManufactor() {
        return productionManufactor;
    }

    /**
     * 生产厂家
     */
    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 设备编号
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编号
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 数量/选择数量/送货数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 数量/选择数量/送货数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }
    /**
     * 租赁方式id
     */
    public Integer getRentTypeId() {
        return rentTypeId;
    }

    /**
     * 租赁方式id
     */
    public void setRentTypeId(Integer rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    /**
     * 租赁方式名称
     */
    public String getRentTypeName() {
        return rentTypeName;
    }

    /**
     * 租赁方式名称
     */
    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    /**
     * 验收单id
     */
    public Long getAcceptanceId() {
        return acceptanceId;
    }

    /**
     * 验收单id
     */
    public void setAcceptanceId(Long acceptanceId) {
        this.acceptanceId = acceptanceId;
    }
    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    public Integer getEquipmentState() {
        return equipmentState;
    }

    /**
     * 设备状态:1--进场,2--启用,3--停用,4--退场
     */
    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }
    /**
     * 设备费用
     */
    public BigDecimal getEquipmentCost() {
        return equipmentCost;
    }

    /**
     * 设备费用
     */
    public void setEquipmentCost(BigDecimal equipmentCost) {
        this.equipmentCost = equipmentCost;
    }
    /**
     * 验收日期
     */
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    /**
     * 验收日期
     */
    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    /**
     * 启动日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 启动日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 停用日期
     */
    public Date getStopDate() {
        return stopDate;
    }

    /**
     * 停用日期
     */
    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }
    /**
     * 退场日期
     */
    public Date getOutDate() {
        return outDate;
    }

    /**
     * 退场日期
     */
    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 有税单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 有税单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 无税单价
     */
    public BigDecimal getNotTaxPrice() {
        return notTaxPrice;
    }

    /**
     * 无税单价
     */
    public void setNotTaxPrice(BigDecimal notTaxPrice) {
        this.notTaxPrice = notTaxPrice;
    }
    /**
     * 验收单明细id
     */
    public Long getAcceptanceDetailId() {
        return acceptanceDetailId;
    }

    /**
     * 验收单明细id
     */
    public void setAcceptanceDetailId(Long acceptanceDetailId) {
        this.acceptanceDetailId = acceptanceDetailId;
    }
    /**
     * 计租日期
     */
    public Date getMeterRentDate() {
        return meterRentDate;
    }

    /**
     * 计租日期
     */
    public void setMeterRentDate(Date meterRentDate) {
        this.meterRentDate = meterRentDate;
    }
    /**
     * 操作日期
     */
    public Date getOperationDate() {
        return operationDate;
    }

    /**
     * 操作日期
     */
    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }
    /**
     * 工程量数量
     */
    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    /**
     * 工程量数量
     */
    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }
    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 是否已计算租金（0-否，1-是）
     */
    public Integer getSettlementFlag() {
        return settlementFlag;
    }

    /**
     * 是否已计算租金（0-否，1-是）
     */
    public void setSettlementFlag(Integer settlementFlag) {
        this.settlementFlag = settlementFlag;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 工程id
     */
    public Long getEngineeringId() {
        return engineeringId;
    }

    /**
     * 工程id
     */
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

}
