package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁结算费用明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁结算费用明细")
public class RentSettlementFeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键")
    private Long settlementId;
    @ApiModelProperty("费用编码")
    private String feeCode;
    @ApiModelProperty("费用Id")
    private Long feeId;
    @ApiModelProperty("费用名称")
    private String feeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("数量")
    private BigDecimal feeNum;
    @ApiModelProperty("单价")
    private BigDecimal feePrice;
    @ApiModelProperty("金额")
    private BigDecimal feeMny;
    @ApiModelProperty("备注")
    private String feeMemo;
    @ApiModelProperty("税率")
    private BigDecimal feeTaxRate;
    @ApiModelProperty("税额")
    private BigDecimal feeTax;
    @ApiModelProperty("金额(含税)")
    private BigDecimal feeTaxMny;
    @ApiModelProperty("单价(含税)")
    private BigDecimal feeTaxPrice;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("合同数量")
    private BigDecimal contractNum;
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }


    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 结算主键
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 费用编码
     */
    public String getFeeCode() {
        return feeCode;
    }

    /**
     * 费用编码
     */
    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }
    /**
     * 费用Id
     */
    public Long getFeeId() {
        return feeId;
    }

    /**
     * 费用Id
     */
    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    /**
     * 费用名称
     */
    public String getFeeName() {
        return feeName;
    }

    /**
     * 费用名称
     */
    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 数量
     */
    public BigDecimal getFeeNum() {
        return feeNum;
    }

    /**
     * 数量
     */
    public void setFeeNum(BigDecimal feeNum) {
        this.feeNum = feeNum;
    }
    /**
     * 单价
     */
    public BigDecimal getFeePrice() {
        return feePrice;
    }

    /**
     * 单价
     */
    public void setFeePrice(BigDecimal feePrice) {
        this.feePrice = feePrice;
    }
    /**
     * 金额
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 金额
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 备注
     */
    public String getFeeMemo() {
        return feeMemo;
    }

    /**
     * 备注
     */
    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }
    /**
     * 税率
     */
    public BigDecimal getFeeTaxRate() {
        return feeTaxRate;
    }

    /**
     * 税率
     */
    public void setFeeTaxRate(BigDecimal feeTaxRate) {
        this.feeTaxRate = feeTaxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getFeeTax() {
        return feeTax;
    }

    /**
     * 税额
     */
    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getFeeTaxPrice() {
        return feeTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setFeeTaxPrice(BigDecimal feeTaxPrice) {
        this.feeTaxPrice = feeTaxPrice;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 合同数量
     */
    public BigDecimal getContractNum() {
        return contractNum;
    }

    /**
     * 合同数量
     */
    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    
}
