package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁日租明细
 * 
 * @author generator
 * 
 */
public class RentDayDetailedVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 设备名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String dayFactoryCode; // 设备出厂编号
    private Long categoryId; // 设备类别id
    private String categoryName; // 设备类别名称
    private String spec; // 规格型号
    private String unitName; // 单位
    private BigDecimal dayRentPrice; // 日租单价
    private BigDecimal stopRentPrice; // 停租单价
    private Integer rentNum; // 租赁数量
    private BigDecimal tax; // 税率
    private BigDecimal dayRentNotTaxPrice; // 日租单价(无税)
    private BigDecimal stopRentNotTaxPrice; // 停租单价(无税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate; // 计划进程日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate; // 计划出场日期
    private String productionManufactor; // 生产厂家
    private String memo; // 备注
    private Long pid; // 主表id
    private String equipmentCode;
    private Long equipmentId;
    private BigDecimal taxMny; //含税金额
    private Long changeBid;
    private Long changeId;//变更子表主键
    private Long sourceId;
    private String meterRentTypeName; // 计租方式名称 参照使用
    @TableField(value="rent_day")
    private BigDecimal rentDay; // 租赁天数
    @TableField(value="rent_mny")
    private BigDecimal rentMny; // 租赁金额(无税)
    @TableField(value="rent_tax_mny")
    private BigDecimal rentTaxMny; // 租赁金额(含税)
    @TableField(value="tax_money")
    private BigDecimal taxMoney; // 税额
    @TableField(value="target_unit_tax_price")
    private BigDecimal targetUnitTaxPrice; //定标单价
    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）


    //模板导出使用
    private String dayRentPriceStr;
    private String stopRentPriceStr;
    private String rentTaxMnyStr;
    private String taxStr;
    private String rentMnyStr;
    private String dayRentNotTaxPriceStr;
    private String stopRentNotTaxPriceStr;
    private String taxMoneyStr;

    public BigDecimal getTargetUnitTaxPrice() {
        return targetUnitTaxPrice;
    }

    public void setTargetUnitTaxPrice(BigDecimal targetUnitTaxPrice) {
        this.targetUnitTaxPrice = targetUnitTaxPrice;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public BigDecimal getRentDay() {
        return rentDay;
    }

    public void setRentDay(BigDecimal rentDay) {
        this.rentDay = rentDay;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getDayFactoryCode() {
        return dayFactoryCode;
    }

    public void setDayFactoryCode(String dayFactoryCode) {
        this.dayFactoryCode = dayFactoryCode;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getDayRentPrice() {
        return dayRentPrice;
    }

    public void setDayRentPrice(BigDecimal dayRentPrice) {
        this.dayRentPrice = dayRentPrice;
    }
    public BigDecimal getStopRentPrice() {
        return stopRentPrice;
    }

    public void setStopRentPrice(BigDecimal stopRentPrice) {
        this.stopRentPrice = stopRentPrice;
    }
    public Integer getRentNum() {
        return rentNum;
    }

    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getDayRentNotTaxPrice() {
        return dayRentNotTaxPrice;
    }

    public void setDayRentNotTaxPrice(BigDecimal dayRentNotTaxPrice) {
        this.dayRentNotTaxPrice = dayRentNotTaxPrice;
    }
    public BigDecimal getStopRentNotTaxPrice() {
        return stopRentNotTaxPrice;
    }

    public void setStopRentNotTaxPrice(BigDecimal stopRentNotTaxPrice) {
        this.stopRentNotTaxPrice = stopRentNotTaxPrice;
    }
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getDayRentPriceStr() {
        return dayRentPriceStr;
    }

    public void setDayRentPriceStr(String dayRentPriceStr) {
        this.dayRentPriceStr = dayRentPriceStr;
    }

    public String getStopRentPriceStr() {
        return stopRentPriceStr;
    }

    public void setStopRentPriceStr(String stopRentPriceStr) {
        this.stopRentPriceStr = stopRentPriceStr;
    }

    public String getRentTaxMnyStr() {
        return rentTaxMnyStr;
    }

    public void setRentTaxMnyStr(String rentTaxMnyStr) {
        this.rentTaxMnyStr = rentTaxMnyStr;
    }

    public String getTaxStr() {
        return taxStr;
    }

    public void setTaxStr(String taxStr) {
        this.taxStr = taxStr;
    }

    public String getRentMnyStr() {
        return rentMnyStr;
    }

    public void setRentMnyStr(String rentMnyStr) {
        this.rentMnyStr = rentMnyStr;
    }

    public String getDayRentNotTaxPriceStr() {
        return dayRentNotTaxPriceStr;
    }

    public void setDayRentNotTaxPriceStr(String dayRentNotTaxPriceStr) {
        this.dayRentNotTaxPriceStr = dayRentNotTaxPriceStr;
    }

    public String getStopRentNotTaxPriceStr() {
        return stopRentNotTaxPriceStr;
    }

    public void setStopRentNotTaxPriceStr(String stopRentNotTaxPriceStr) {
        this.stopRentNotTaxPriceStr = stopRentNotTaxPriceStr;
    }

    public String getTaxMoneyStr() {
        return taxMoneyStr;
    }

    public void setTaxMoneyStr(String taxMoneyStr) {
        this.taxMoneyStr = taxMoneyStr;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
}
