package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 租金计算日租明细
 * 
 * @author generator
 * 
 */
@ApiModel("租金计算日租明细")
public class RentRentalDayVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("设备出厂编号")
    private String dayFactoryCode;
    @ApiModelProperty("设备类别id")
    private Long categoryId;
    @ApiModelProperty("设备类别名称")
    private String categoryName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unitName;
    @ApiModelProperty("日租单价")
    private BigDecimal dayRentPrice;
    @ApiModelProperty("停租单价")
    private BigDecimal stopRentPrice;
    @ApiModelProperty("租赁数量")
    private Integer rentNum;
    @ApiModelProperty("税率")
    private BigDecimal tax;
    @ApiModelProperty("日租单价(无税)")
    private BigDecimal dayRentNotTaxPrice;
    @ApiModelProperty("停租单价(无税)")
    private BigDecimal stopRentNotTaxPrice;
    @ApiModelProperty("计划进程日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate;
    @ApiModelProperty("计划出场日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate;
    @ApiModelProperty("生产厂家")
    private String productionManufactor;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("主表id")
    private Long rentalId;
    @ApiModelProperty("设备编号")
    private String equipmentCode;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("含税金额")
    private BigDecimal taxMny;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentDayMny;
    @ApiModelProperty("租赁金额")
    private BigDecimal rentDayTaxMny;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentDayTax;
    @ApiModelProperty("计费开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date chargingStartDate;
    @ApiModelProperty("计费结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date chargingEndDate;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;

    @ApiModelProperty("设备状态:1--进场,2--启用,3--停用,4--退场")
    private Integer equipmentState;
    private Integer rentDayDate;

    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    public Integer getEquipmentState() {
        return equipmentState;
    }

    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }

    public Integer getRentDayDate() {
        return rentDayDate;
    }

    public void setRentDayDate(Integer rentDayDate) {
        this.rentDayDate = rentDayDate;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备出厂编号
     */
    public String getDayFactoryCode() {
        return dayFactoryCode;
    }

    /**
     * 设备出厂编号
     */
    public void setDayFactoryCode(String dayFactoryCode) {
        this.dayFactoryCode = dayFactoryCode;
    }
    /**
     * 设备类别id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 设备类别id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 设备类别名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 设备类别名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 日租单价
     */
    public BigDecimal getDayRentPrice() {
        return dayRentPrice;
    }

    /**
     * 日租单价
     */
    public void setDayRentPrice(BigDecimal dayRentPrice) {
        this.dayRentPrice = dayRentPrice;
    }
    /**
     * 停租单价
     */
    public BigDecimal getStopRentPrice() {
        return stopRentPrice;
    }

    /**
     * 停租单价
     */
    public void setStopRentPrice(BigDecimal stopRentPrice) {
        this.stopRentPrice = stopRentPrice;
    }
    /**
     * 租赁数量
     */
    public Integer getRentNum() {
        return rentNum;
    }

    /**
     * 租赁数量
     */
    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    /**
     * 税率
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税率
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 日租单价(无税)
     */
    public BigDecimal getDayRentNotTaxPrice() {
        return dayRentNotTaxPrice;
    }

    /**
     * 日租单价(无税)
     */
    public void setDayRentNotTaxPrice(BigDecimal dayRentNotTaxPrice) {
        this.dayRentNotTaxPrice = dayRentNotTaxPrice;
    }
    /**
     * 停租单价(无税)
     */
    public BigDecimal getStopRentNotTaxPrice() {
        return stopRentNotTaxPrice;
    }

    /**
     * 停租单价(无税)
     */
    public void setStopRentNotTaxPrice(BigDecimal stopRentNotTaxPrice) {
        this.stopRentNotTaxPrice = stopRentNotTaxPrice;
    }
    /**
     * 计划进程日期
     */
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    /**
     * 计划进程日期
     */
    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    /**
     * 计划出场日期
     */
    public Date getPlanOutDate() {
        return planOutDate;
    }

    /**
     * 计划出场日期
     */
    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    /**
     * 生产厂家
     */
    public String getProductionManufactor() {
        return productionManufactor;
    }

    /**
     * 生产厂家
     */
    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 主表id
     */
    public Long getRentalId() {
        return rentalId;
    }

    /**
     * 主表id
     */
    public void setRentalId(Long rentalId) {
        this.rentalId = rentalId;
    }
    /**
     * 设备编号
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编号
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 含税金额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 含税金额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentDayMny() {
        return rentDayMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentDayMny(BigDecimal rentDayMny) {
        this.rentDayMny = rentDayMny;
    }
    /**
     * 租赁金额
     */
    public BigDecimal getRentDayTaxMny() {
        return rentDayTaxMny;
    }

    /**
     * 租赁金额
     */
    public void setRentDayTaxMny(BigDecimal rentDayTaxMny) {
        this.rentDayTaxMny = rentDayTaxMny;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentDayTax() {
        return rentDayTax;
    }

    /**
     * 租赁税额
     */
    public void setRentDayTax(BigDecimal rentDayTax) {
        this.rentDayTax = rentDayTax;
    }
    /**
     * 计费开始日期
     */
    public Date getChargingStartDate() {
        return chargingStartDate;
    }

    /**
     * 计费开始日期
     */
    public void setChargingStartDate(Date chargingStartDate) {
        this.chargingStartDate = chargingStartDate;
    }
    /**
     * 计费结束日期
     */
    public Date getChargingEndDate() {
        return chargingEndDate;
    }

    /**
     * 计费结束日期
     */
    public void setChargingEndDate(Date chargingEndDate) {
        this.chargingEndDate = chargingEndDate;
    }
    
}
