package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁结算租金明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁结算租金明细")
public class RentSettlementRentalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("租金计算日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentalCountDate;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentalMny;
    @ApiModelProperty("租赁金额)")
    private BigDecimal rentalTaxMny;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentalTax;
    @ApiModelProperty("备注")
    private String memo;
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }


    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(记录—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(记录—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 租金计算日期
     */
    public Date getRentalCountDate() {
        return rentalCountDate;
    }

    /**
     * 租金计算日期
     */
    public void setRentalCountDate(Date rentalCountDate) {
        this.rentalCountDate = rentalCountDate;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentalMny() {
        return rentalMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentalMny(BigDecimal rentalMny) {
        this.rentalMny = rentalMny;
    }
    /**
     * 租赁金额)
     */
    public BigDecimal getRentalTaxMny() {
        return rentalTaxMny;
    }

    /**
     * 租赁金额)
     */
    public void setRentalTaxMny(BigDecimal rentalTaxMny) {
        this.rentalTaxMny = rentalTaxMny;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentalTax() {
        return rentalTax;
    }

    /**
     * 租赁税额
     */
    public void setRentalTax(BigDecimal rentalTax) {
        this.rentalTax = rentalTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
