/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.temporary.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementService;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="temporarySettlement")
public class TemporarySettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITemporarySettlementService service;
    @Autowired
    private ITemporaryContractService temporaryContractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            boolean pool;
            this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
            TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)this.service.selectById(billId));
            TemporarySettlementVO settlementVO = (TemporarySettlementVO)BeanMapper.map((Object)((Object)entity), TemporarySettlementVO.class);
            if (entity.getContractId() != null && entity.getSettlementType() == 1) {
                TemporaryContractEntity temporaryContractEntity = (TemporaryContractEntity)((Object)this.temporaryContractService.selectById(entity.getContractId()));
                temporaryContractEntity.setContractPerformanceState("3");
                this.temporaryContractService.saveOrUpdate((Object)temporaryContractEntity);
                this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)temporaryContractEntity)));
            }
            if (!(pool = this.service.pushSettleToPool(settlementVO))) {
                throw new BusinessException("\u63a8\u9001\u7ed3\u7b97\u5931\u8d25");
            }
            if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
                this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5f00\u59cb");
                CommonResponse response = this.executionApi.aggPush(this.service.targetCost(entity));
                this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.service.targetCost(entity)));
                if (!response.isSuccess()) {
                    this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                    throw new BusinessException(response.getMsg());
                }
            }
            this.logger.info("\u63a8\u9001\u6210\u672c---");
            this.service.costPush(entity);
            boolean pushFlag = this.service.pushBillToSupCenter(entity, billTypeCode);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
            if (!pushFlag) {
                entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            }
            this.service.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(TemporarySettlementEntity::getContractId, (Object)entity.getContractId());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List list = this.service.list((Wrapper)lambda);
            TemporarySettlementEntity settlementEntity = (TemporarySettlementEntity)((Object)list.get(0));
            if (!entity.getId().equals(settlementEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pool;
        TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSettlementType() == 1) {
            TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.temporaryContractService.selectById(entity.getContractId()));
            contractEntity.setContractPerformanceState("2");
            this.temporaryContractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        if (!(pool = this.service.delSettleFromPool(billId))) {
            throw new BusinessException("\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01");
        }
        if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO = this.service.targetCost(entity);
            totalExecutionVOList.add(executionVO.getTotalVO());
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u5220\u9664\u76ee\u6807\u6210\u672c\u7ed3\u679c" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-Id---{}", (Object)entity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(entity, billTypeCode);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(TemporarySettlementEntity::getRelationFlag, (Object)"0");
        updateWrapper.set(TemporarySettlementEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

