/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.order.service.impl;

import com.ejianc.business.order.bean.RentOrderEntity;
import com.ejianc.business.order.service.IRentOrderService;
import com.ejianc.business.proequipmentcorpout.order.api.IOutCorpOrderApi;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentOrder")
public class RentOrderBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRentOrderService rentOrderService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IOutCorpOrderApi outCorpOrderApi;
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentOrder/deleteOrder";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.rentOrderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.rentContractService.getById(orderEntity.getContractId()));
        this.logger.info("\u8c03\u7528----{}", (Object)rentContractEntity.getRentHarborType());
        if (rentContractEntity.getRentHarborType() == 1) {
            return this.toBillToCorpCenter(orderEntity, state, billTypeCode);
        }
        return this.toBillToSupCenter(orderEntity, state, billTypeCode);
    }

    public CommonResponse<String> toBillToSupCenter(RentOrderEntity orderEntity, Integer state, String billTypeCode) {
        Boolean pushFlag = this.rentOrderService.pushBillToSupCenter(orderEntity, billTypeCode);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
        if (pushFlag.booleanValue()) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
                orderEntity.setCommitId(InvocationInfoProxy.getUserid());
            }
        } else {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5931\u8d25");
        }
        orderEntity.setReceiveState(0);
        this.rentOrderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> toBillToCorpCenter(RentOrderEntity orderEntity, Integer state, String billTypeCode) {
        Boolean pushFlag = this.rentOrderService.pushBillToCorpCenter(orderEntity, billTypeCode);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u8bbe\u5907\u516c\u53f8\u7ed3\u679c--" + pushFlag);
        if (pushFlag.booleanValue()) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
                orderEntity.setCommitId(InvocationInfoProxy.getUserid());
            }
        } else {
            return CommonResponse.error((String)"\u63a8\u9001\u8bbe\u5907\u516c\u53f8\u5931\u8d25");
        }
        orderEntity.setReceiveState(0);
        this.rentOrderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        if ("1".equals(orderEntity.getRentType()) || StringUtils.isBlank((CharSequence)orderEntity.getRentType())) {
            OutOrderVO outOrderVO = (OutOrderVO)BeanMapper.map((Object)((Object)orderEntity), OutOrderVO.class);
            outOrderVO.setOutOrderDetailList(BeanMapper.mapList((Iterable)outOrderVO.getOutOrderDetailList(), OutOrderDetailVO.class));
            this.outCorpOrderApi.deleteOrder(outOrderVO);
        }
        if (orderEntity.getReceiveState() == 0) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)this.rentOrderService.selectById(billId));
        if (!orderEntity.getRentType().equals("1")) {
            return this.rentOrderService.updatePushBill(orderEntity, billTypeCode, "/ejc-supbusiness-web/openapi/equipmentOrder/deleteOrder");
        }
        return CommonResponse.success();
    }
}

