/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractFreezeEntity;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.service.IRentContractFreezeService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="rentContractFreeze")
public class RentContractFreezeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentContractFreezeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRentContractService rentContractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RentContractFreezeEntity e = (RentContractFreezeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.logger.info("======\u7ec8\u5ba1\u524d\u56de\u8c03======,{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u51bb\u7ed3\u89e3\u51bb\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RentContractFreezeEntity e = (RentContractFreezeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.logger.info("======\u63d0\u4ea4\u5b8c\u56de\u8c03======,{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u51bb\u7ed3\u89e3\u51bb\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u51bb\u7ed3\u4e0d\u652f\u6301\u64a4\u56de");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentContractFreezeEntity e = (RentContractFreezeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.logger.info("======\u7ec8\u5ba1\u524d\u56de\u8c03======,{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u51bb\u7ed3\u89e3\u51bb\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterApprovalProcessor \u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03 \u89e6\u53d1");
        RentContractFreezeEntity entity = (RentContractFreezeEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            entity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)entity, false);
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("eq", (Object)entity.getContractId()));
            this.logger.error("\u5408\u540c\u67e5\u8be2\u53c2\u6570" + JSONObject.toJSONString((Object)param));
            List contractEntities = this.rentContractService.queryList(param, false);
            if (entity.getContractPerformanceState() == 5) {
                ((RentContractEntity)((Object)contractEntities.get(0))).setContractPerformanceState(ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode());
            } else if (entity.getContractPerformanceState() == 2) {
                ((RentContractEntity)((Object)contractEntities.get(0))).setContractPerformanceState(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            }
            this.logger.error("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03" + JSONObject.toJSONString(contractEntities.get(0)));
            this.rentContractService.saveOrUpdate(contractEntities.get(0), false);
            this.rentContractService.pushContract((RentContractVO)BeanMapper.map(contractEntities.get(0), RentContractVO.class));
        }
        return CommonResponse.success((String)"\u5408\u540c\u51bb\u7ed3/\u89e3\u51bb \u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u5904\u7406\u6210\u529f!\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u51bb\u7ed3\u4e0d\u652f\u6301\u64a4\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentContractFreezeEntity entity = (RentContractFreezeEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentContractFreezeEntity::getContractId, (Object)entity.getContractId());
        wrapper.in(RentContractFreezeEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            RentContractFreezeEntity freezeEntity = (RentContractFreezeEntity)((Object)list.get(0));
            if (freezeEntity.getId().equals(billId)) {
                RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.getById(entity.getContractId()));
                if (contractEntity.getContractState().equals(ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode())) {
                    contractEntity.setContractState(ContractStatusEnum.\u5df2\u51bb\u7ed3.getCode());
                } else if (contractEntity.getContractState().equals(ContractStatusEnum.\u5df2\u51bb\u7ed3.getCode())) {
                    contractEntity.setContractState(ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
                this.rentContractService.save((Object)contractEntity);
            } else {
                throw new BusinessException("\u5b58\u5728\u66f4\u665a\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de/\u5f03\u5ba1\uff01");
            }
        }
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

