/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.rent.bean.RentContractChangeEntity;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractFreezeEntity;
import com.ejianc.business.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.mapper.RentContractMapper;
import com.ejianc.business.rent.service.IRentContractAsyncService;
import com.ejianc.business.rent.service.IRentContractChangeService;
import com.ejianc.business.rent.service.IRentContractFreezeService;
import com.ejianc.business.rent.service.IRentContractRelieveService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.utils.ListCallable;
import com.ejianc.business.rent.vo.RentContractChangeVO;
import com.ejianc.business.rent.vo.RentContractEquipmentAllVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.rent.vo.RentDayDetailedVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRentApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="rentContractService")
public class RentContractServiceImpl
extends BaseServiceImpl<RentContractMapper, RentContractEntity>
implements IRentContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IRentContractChangeService rentContractChangeService;
    @Autowired
    private IRentContractFreezeService rentContractFreezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ITenderRentApi tenderApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    int unOccupyState = 0;
    int occupyState = 1;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRentContractRelieveService rentContractRelieveService;
    private final String RENT_CONTRACT = "BT220303000000002";
    private static final String BILL_CODE = "RENT_CONTRACT";
    private static final String BILL_CODE_YNJT = "RENT_CONTRACT_YNJT01";
    private static final String GenerateSourceType = "SPZLSPZR10086";
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_SUP_CODE = "P-oOnHR591";
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-Msv0xc0196";
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-H2vDc40195";
    @Autowired
    private IRentContractService service;
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentContractChangeService contractChangeService;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IRentContractAsyncService rentContractAsyncService;

    @Override
    public RentContractVO saveOrUpdateSupplement(RentContractVO rentContractVO, String authority) {
        QueryParam param;
        RentContractEntity entity;
        CommonResponse orgResponse;
        List entities = null;
        List entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.service.selectById(rentContractVO.getMainContractId()));
        if (null == rentContractEntity) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)rentContractVO.getParentOrgCode()) && rentContractVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(rentContractVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            rentContractVO.setParentOrgCode(orgVO.getCode());
        }
        if ((entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVO, RentContractEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setSupplementFlag(1);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)rentContractVO.getMainContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            param.getParams().put("bill_state", new Parameter("in", billStateList));
            List supplementList = this.service.queryList(param, false);
            if (StringUtils.isBlank((CharSequence)entity.getCode())) {
                String supplementNum = "";
                supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
                entity.setCode(rentContractEntity.getCode() + "2" + supplementNum);
            }
        }
        if (rentContractVO.getId() != null && rentContractVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getCode, (Object)rentContractVO.getCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVO.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("code", new Parameter("eq", (Object)rentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)rentContractVO.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)rentContractVO.getMainContractId()));
            List supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureState().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getCode, (Object)rentContractVO.getCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("code", new Parameter("eq", (Object)rentContractVO.getCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.checkContract(rentContractVO.getMainContractId(), rentContractVO.getId());
        entity.setBaseMny(rentContractVO.getContractMny() == null ? BigDecimal.ZERO : rentContractVO.getContractMny());
        entity.setBaseTaxMny(rentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVO.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVO.getContractMny() == null ? BigDecimal.ZERO : rentContractVO.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVO.getContractTaxMny());
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                RentContractEntity contract = (RentContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                this.service.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFile(null);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        RentContractVO vo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        return vo;
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        RentContractEntity contractEntity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureState", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureState", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.contractChangeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        QueryParam queryRelParam = new QueryParam();
        queryRelParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryRelParam.getParams().put("signature_state", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List relieveEntityList = this.rentContractRelieveService.queryList(queryRelParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureState");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.rentContractFreezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public RentContractVO addConvertByConId(Long contractId) {
        RentContractEntity entity = (RentContractEntity)((Object)super.selectById((Serializable)contractId));
        RentContractVO supplementVO = new RentContractVO();
        supplementVO.setTargetResultId(entity.getTargetResultId());
        supplementVO.setTargetResultName(entity.getTargetResultName());
        supplementVO.setPartyHandleUser(entity.getPartyHandleUser());
        supplementVO.setPartyHandleUserName(entity.getPartyHandleUserName());
        supplementVO.setPartyPhone(entity.getPartyPhone());
        supplementVO.setSupplierHandleUser(entity.getSupplierHandleUser());
        supplementVO.setSupplierHandleUserName(entity.getSupplierHandleUserName());
        supplementVO.setSupplierPhone(entity.getSupplierPhone());
        supplementVO.setMainContractCode(entity.getCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setMainContractName(entity.getContractName());
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setContractTypeName(entity.getContractTypeName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setProjectAddress(entity.getProjectAddress());
        supplementVO.setPartyId(entity.getPartyId());
        supplementVO.setPartyName(entity.getPartyName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setParentOrgId(entity.getParentOrgId());
        supplementVO.setParentOrgName(entity.getParentOrgName());
        supplementVO.setParentOrgCode(entity.getParentOrgCode());
        supplementVO.setSignedDate(new Date());
        supplementVO.setSupplementFlag(RentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        supplementVO.setContractPerformanceState(ContractPerformanceStateEnum.\u672a\u7b7e\u8ba2.getStateCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setName(entity.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setMainContractCreateDate(entity.getMainContractCreateDate());
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setMeterRentType(entity.getMeterRentType());
        supplementVO.setMeterRentTypeName(entity.getMeterRentTypeName());
        supplementVO.setContractName(entity.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setCompanyId(entity.getCompanyId());
        supplementVO.setCompanyName(entity.getCompanyName());
        supplementVO.setRentType(entity.getRentType());
        supplementVO.setRentTypeName(entity.getRentTypeName());
        supplementVO.setRentHarborType(entity.getRentHarborType());
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        supplementVO.setSupplementName(entity.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setMonthSettlement(entity.getMonthSettlement());
        supplementVO.setMeterDate(entity.getMeterDate());
        supplementVO.setPreventDate(entity.getPreventDate());
        supplementVO.setContractTax(entity.getContractTax());
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        RentContractEntity contractEntity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        if (!ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode().equals(contractEntity.getContractPerformanceState())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(RentContractEntity::getMainContractId, (Object)id);
        lambda.eq(RentContractEntity::getSupplementFlag, (Object)1);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(RentContractEntity::getSignatureState, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(RentContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(RentContractVO contractVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getCode());
        totalVO.setBillType("BT220303000000002");
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = RentContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public RentContractVO querySupplementRecord(Long id) {
        RentContractEntity contractEntity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        RentContractVO contractVO = new RentContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"contract_performance_state", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, RentContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (RentContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureState()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(contractEntity.getContractPerformanceState()) && !ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode().equals(contractEntity.getContractPerformanceState())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    @Override
    public void pushContract(RentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setPcCardUrl("/ejc-proequipment-frontend/#/leaseContract/cardList?id=" + contractVO.getId() + "&showTitle=true&supplementFlag=" + contractVO.getSupplementFlag());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        c2.getParams().put("signature_state", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        c1.getComplexParams().add(c2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(c1);
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam2.getComplexParams().add(c1);
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam3.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = (QueryParam)BeanMapper.map((Object)queryParam, QueryParam.class);
        QueryParam param2 = (QueryParam)BeanMapper.map((Object)queryParam2, QueryParam.class);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)queryParam3);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
            param2.getParams().put("id", new Parameter("ne", (Object)billId));
            param3.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, "\u8865\u5145\u534f\u8bae".equals(billType) ? param : queryParam, this.service);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, "\u53d8\u66f4\u5355".equals(billType) ? param2 : queryParam2, this.contractChangeService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, "\u89e3\u9664\u5355".equals(billType) ? param2 : queryParam2, this.rentContractRelieveService);
        Future<JSONArray> future4 = ListCallable.excute(threadPool, "\u51bb\u7ed3\u5355".equals(billType) ? param3 : queryParam3, this.rentContractFreezeService);
        List supplementList = new ArrayList();
        List changeList = new ArrayList();
        List relieveList = new ArrayList();
        List freezeList = new ArrayList();
        try {
            supplementList = JSONObject.parseArray((String)future1.get().toJSONString(), RentContractEntity.class);
            changeList = JSONObject.parseArray((String)future2.get().toJSONString(), RentContractChangeEntity.class);
            relieveList = JSONObject.parseArray((String)future3.get().toJSONString(), RentContractRelieveEntity.class);
            freezeList = JSONObject.parseArray((String)future4.get().toJSONString(), RentContractFreezeEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(changeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(freezeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(relieveList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u89e3\u9664\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    private void clearBaseFields(RentContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    @Override
    public IPage<RentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> param) {
        Page page = new Page();
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        Integer count = this.rentContractMapper.countNumber(param);
        if (count > 0) {
            List<RentContractEquipmentAllVO> appEntity = this.rentContractMapper.queryEquipmentSubList(param);
            page.setRecords(appEntity);
        } else {
            page.setRecords(new ArrayList());
        }
        if (param.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal((long)count.intValue());
        }
        return page;
    }

    @Override
    public Boolean delContractFile(Long contractFileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", contractFileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<RentContractVO> vos) {
        vos.forEach(contractVO -> {
            RentContractEntity contractEntity = (RentContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                CommonResponse tender = this.tenderApi.updateById(contractEntity.getTargetResultId(), Integer.valueOf(0));
                this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
            }
        });
        this.removeByIds(vos.stream().map(RentContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public RentContractEntity selectCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.rentContractMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (RentContractEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public void pushDelContract(RentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setSourceId(contractVO.getId());
            this.logger.info("\u5f00\u59cb\u5220\u9664\u5408\u540c\u6c60\u5408\u540c>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.deleteContract(data);
            this.logger.info("\u5220\u9664\u5408\u540c\u6c60\u5408\u540c\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVO, String authority, Boolean isControl) {
        RentContractEntity contract;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        CommonResponse orgResponse;
        List entities = null;
        List entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (rentContractVO.getOrgId() != null && (StringUtils.isEmpty((CharSequence)rentContractVO.getOrgCode()) || StringUtils.isEmpty((CharSequence)rentContractVO.getParentOrgCode()) || StringUtils.isEmpty((CharSequence)rentContractVO.getOrgName())) && (orgResponse = this.iOrgApi.getOneById(rentContractVO.getOrgId())).isSuccess()) {
            Object orgVO = (OrgVO)orgResponse.getData();
            rentContractVO.setOrgCode(orgVO.getCode());
            if (StringUtils.isEmpty((CharSequence)rentContractVO.getOrgName())) {
                rentContractVO.setOrgName(orgVO.getName());
            }
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    rentContractVO.setParentOrgId(parentOrgVO.getId());
                    rentContractVO.setParentOrgCode(parentOrgVO.getCode());
                    rentContractVO.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                rentContractVO.setParentOrgId(rentContractVO.getOrgId());
                rentContractVO.setParentOrgCode(rentContractVO.getOrgCode());
                rentContractVO.setParentOrgName(rentContractVO.getOrgName());
            }
        }
        RentContractEntity entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVO, RentContractEntity.class));
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (!isControl.booleanValue()) {
            if (entity.getId() == null || entity.getId() == 0L) {
                entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
            }
            if (StringUtils.isEmpty((CharSequence)entity.getCode())) {
                switch (this.GenerateBillCodeType) {
                    case "common": {
                        CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)rentContractVO));
                        if (!billCode.isSuccess()) {
                            this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        entity.setCode((String)billCode.getData());
                        break;
                    }
                    case "ynjt": {
                        CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)rentContractVO));
                        if (!billCodeFirstPart.isSuccess()) {
                            this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        CommonSNVO commonSNVO = new CommonSNVO();
                        commonSNVO.setSnLength(Integer.valueOf(4));
                        commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                        commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                        commonSNVO.setSourceType(GenerateSourceType);
                        CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                        if (!snResp.isSuccess()) {
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        entity.setCode((String)billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + (String)snResp.getData());
                        rentContractVO.setCode(entity.getCode());
                    }
                }
            }
        }
        if (rentContractVO.getId() != null && rentContractVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getCode, (Object)rentContractVO.getCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVO.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("code", new Parameter("eq", (Object)rentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)rentContractVO.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getCode, (Object)rentContractVO.getCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("code", new Parameter("eq", (Object)rentContractVO.getCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (RentContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractType().equals(entity.getContractType()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFile(null);
        }
        if (!isControl.booleanValue()) {
            boolean saveFlag;
            if (entity.getFilingStatus() == null) {
                entity.setFilingRef(0);
            }
            RentContractEntity rentContractEntityTarget = null;
            if (rentContractVO.getId() != null) {
                rentContractEntityTarget = (RentContractEntity)((Object)super.selectById((Serializable)rentContractVO.getId()));
            }
            if (!(saveFlag = super.saveOrUpdate((Object)entity, false))) {
                throw new BusinessException("\u5408\u540c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            if (entity.getTargetResultId() != null) {
                this.validateTargetMny(entity);
            }
            if (rentContractVO.getId() == null && rentContractVO.getTargetResultId() != null) {
                this.updateTargetResult(entity, 0);
            }
            if (rentContractVO.getId() != null && rentContractVO.getTargetResultId() != null && rentContractEntityTarget != null) {
                this.updateTargetResult(rentContractEntityTarget, 1);
                this.updateTargetResult(entity, 0);
            }
            String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + entity.getId();
            ExecutionVO executionVO = this.service.targetCost((RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class), linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        RentContractVO vo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public ParamsCheckVO targetCostCtrl(RentContractVO contractVO, String authority) {
        RentContractVO contractVO1 = (RentContractVO)this.saveOrUpdate(contractVO, authority, true).getData();
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO1.getId();
        ExecutionVO executionVO = this.service.targetCost(contractVO1, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentContractVO contractVO = this.queryDetail(id);
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO.getId();
        ExecutionVO executionVO = this.service.targetCost(contractVO, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.service.selectById(id));
        RentContractVO vo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        CommonResponse response;
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.service.selectById(id));
        if (ContractStatusEnum.\u5df2\u4f5c\u5e9f.getCode().toString().equals(rentContractEntity.getContractPerformanceState())) {
            QueryWrapper relieveQueryWrapper = new QueryWrapper();
            relieveQueryWrapper.eq((Object)"contract_id", (Object)id);
            RentContractRelieveEntity rentContractRelieveEntity = (RentContractRelieveEntity)((Object)this.rentContractRelieveService.getOne((Wrapper)relieveQueryWrapper));
            ExecutionVO executionVO = this.rentContractRelieveService.targetCost(rentContractRelieveEntity);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        QueryWrapper rentContractChangeEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)rentContractChangeEntityQueryWrapper.eq((Object)"contract_id", (Object)id)).orderByDesc((Object)"create_time");
        ExecutionVO executionVO = new ExecutionVO();
        List contractChangeEntityList = this.rentContractChangeService.list((Wrapper)rentContractChangeEntityQueryWrapper);
        if (contractChangeEntityList.size() > 0) {
            RentContractChangeEntity rentContractChangeEntity = (RentContractChangeEntity)((Object)this.rentContractChangeService.selectById(((RentContractChangeEntity)((Object)contractChangeEntityList.get(0))).getId()));
            executionVO = this.rentContractChangeService.targetCost((RentContractChangeVO)BeanMapper.map((Object)((Object)rentContractChangeEntity), RentContractChangeVO.class), null);
        } else {
            RentContractVO rentContractVO = this.service.queryDetail(id);
            String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + rentContractVO.getId();
            executionVO = this.service.targetCost(rentContractVO, linkUrl);
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(RentContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), RentContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        paramsCheckVOS.addAll(this.historyPriceCtrlContractPrice(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(RentContractVO contractVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("proequipment---RentContractServiceImpl---historyPriceCtrlContractPrice()--- \u5386\u53f2\u4ef7\u63a7\u5408\u540c\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        List dayDetailList = contractVO.getRentDayDetailedList();
        List monthDetailList = contractVO.getRentMonthDetailedList();
        List quantitiesDetailList = contractVO.getRentQuantitiesDetailedList();
        maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-Msv0xc0196", contractVO.getOrgId());
        minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-H2vDc40195", contractVO.getOrgId());
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u8bbe\u5907\u79df\u8d41\u5408\u540c\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u8bbe\u5907\u79df\u8d41\u5408\u540c\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                BigDecimal maxPriceParam;
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (RentDayDetailedVO detailVO : dayDetailList) {
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getDayRentPrice() == null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getName());
                    paramsCheckDsVO.setWarnName("\u65e5\u79df\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u65e5\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                for (RentDayDetailedVO detailVO : monthDetailList) {
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getMonthRentPrice() == null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getName());
                    paramsCheckDsVO.setWarnName("\u6708\u79df\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6708\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                for (RentDayDetailedVO detailVO : quantitiesDetailList) {
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getQuantitiesPrice() == null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getName());
                    paramsCheckDsVO.setWarnName("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                BigDecimal minPriceParam;
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (RentDayDetailedVO detailVO : dayDetailList) {
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getDayRentPrice() == null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getName());
                    paramsCheckDsVO.setWarnName("\u65e5\u79df\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u65e5\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                for (RentDayDetailedVO detailVO : monthDetailList) {
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getMonthRentPrice() == null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getName());
                    paramsCheckDsVO.setWarnName("\u6708\u79df\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6708\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                for (RentDayDetailedVO detailVO : quantitiesDetailList) {
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getQuantitiesPrice() == null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getName());
                    paramsCheckDsVO.setWarnName("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(RentContractVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(), vo.getOrgId());
        this.logger.info("\u65bd\u5de5\u5408\u540c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response.getData()));
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u5931\u8d25!" + response.getMsg());
        }
        return (List)response.getData();
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(RentContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        RentContractEntity contractEntity = (RentContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureState", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (RentContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUP_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u534f\u8bae\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(RentContractVO vo) {
        CommonResponse billParamByCode;
        List list;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        BigDecimal planTaxMny = BigDecimal.ZERO;
        BigDecimal totalMoney = contractTaxMny;
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(RentTotalPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(RentTotalPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        List planList = this.rentTotalPlanService.list((Wrapper)planLambda);
        if (!CollectionUtils.isNotEmpty((Collection)planList)) {
            return paramsCheckVOList;
        }
        planTaxMny = planList.stream().filter(e -> e.getTemporaryAmount() != null).map(RentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(RentContractEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.orderByDesc(BaseEntity::getCreateTime);
        if (vo.getId() != null) {
            Lambda.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)Lambda)))) {
            List<Long> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<RentContractChangeVO> contractChangeList = ((RentContractMapper)this.baseMapper).getRentContractChangeList(collect);
            Map<Long, RentContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(RentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<RentSettlementVO> settlementList = ((RentContractMapper)this.baseMapper).getRentSettlementList(collect);
            Map<Long, RentSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(RentSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (RentContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;
                if (ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode().equals(entity.getContractPerformanceState()) || ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(entity.getContractPerformanceState())) {
                    if (mapSettle.containsKey(entity.getId())) {
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }
                } else {
                    zero = mapChange.containsKey(entity.getId()) ? mapChange.get(entity.getId()).getContractTaxMny() : entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd((BigDecimal)zero, (BigDecimal)totalMoney);
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse res = this.paymentApplyApi.queryJsonByContractId(id);
        if (!res.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4ed8\u6b3e\u8be6\u60c5\u5931\u8d25!");
        }
        return (ContractPaymentResultVO)res.getData();
    }

    @Override
    public void updateTargetResult(RentContractEntity vo, Integer type) {
        if (vo.getTargetResultId() == null) {
            return;
        }
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId());
        picketageVO.setContractMoneyTax(vo.getContractTaxMny());
        picketageVO.setContractMoney(vo.getContractMny());
        ArrayList list = new ArrayList();
        picketageVO.setTenderPicketageDetailList(list);
        String typeStr = 0 == type ? "\u5360\u7528" : "\u91ca\u653e";
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)picketageVO));
        CommonResponse response = 0 == type ? this.tenderApi.updateStatus(picketageVO) : this.tenderApi.delUpdateStatus(picketageVO);
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "\u5b9a\u6807\u7ed3\u679c\u5931\u8d25\uff01");
        }
    }

    @Override
    public Boolean validateTargetMny(RentContractEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentContractEntity::getTargetResultId, (Object)entity.getTargetResultId());
        if (entity.getId() != null) {
            wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumContractTaxMny = list.stream().map(RentContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ((sumContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumContractTaxMny, (BigDecimal)entity.getContractTaxMny())).compareTo(entity.getTargetTaxMny()) > 0) {
            throw new BusinessException("\u5408\u540c\u7d2f\u8ba1\u7b7e\u8ba2\u91d1\u989d\u8d85\u8fc7\u5b9a\u6807\u91d1\u989d\uff0c\u4e0d\u53ef\u4fdd\u5b58\uff01");
        }
        return true;
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        ArrayList<SignContractVo> rtnList = new ArrayList<SignContractVo>();
        if (CollectionUtils.isEmpty(targetResultIdList)) {
            return rtnList;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter("in", targetResultIdList));
        queryParam.getOrderMap().put("signedDate", "desc");
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return rtnList;
        }
        for (RentContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignedDate());
            vo.setBillState(entity.getBillState());
            String url = "/ejc-proequipment-frontend/#/leaseContract/cardList?id=" + entity.getId() + "&showTitle=true";
            vo.setLinkUrl(url);
            rtnList.add(vo);
        }
        return rtnList;
    }

    @Override
    public void asyncWatermarkById(Long id) {
        RentContractEntity contractEntity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        this.logger.info("valueData" + valueData);
        if ("0".equals(valueData)) {
            this.logger.info("valueData" + valueData);
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(), contractEntity.getCode(), "BT220303000000002", "proRentContractWater");
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.rentContractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(rentContractEntity.getFilingStatus());
    }

    @Override
    public void delChangeById(Long id) {
        this.rentContractMapper.delChangeById(id);
    }

    @Override
    public void delRecordById(Long id) {
        this.rentContractMapper.delRecordById(id);
    }

    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public void delById(Long id) {
        this.rentContractMapper.delById(id);
    }
}

