/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.rent.bean.RentChangeTotalPlanEntity;
import com.ejianc.business.rent.bean.RentChangeTotalPlanSubEntity;
import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.bean.RentTotalPlanHistoryEntity;
import com.ejianc.business.rent.bean.RentTotalPlanHistorySubEntity;
import com.ejianc.business.rent.bean.RentTotalPlanSubEntity;
import com.ejianc.business.rent.mapper.RentTotalPlanMapper;
import com.ejianc.business.rent.service.IRentChangeTotalPlanService;
import com.ejianc.business.rent.service.IRentTotalPlanHistoryService;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.service.IRentTotalPlanSubService;
import com.ejianc.business.rent.vo.RentChangeTotalPlanSubVO;
import com.ejianc.business.rent.vo.RentTotalPlanSubVO;
import com.ejianc.business.rent.vo.RentTotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rentTotalPlanService")
public class RentTotalPlanServiceImpl
extends BaseServiceImpl<RentTotalPlanMapper, RentTotalPlanEntity>
implements IRentTotalPlanService {
    @Autowired
    private IRentTotalPlanSubService rentTotalPlanSubService;
    @Autowired
    private IRentTotalPlanHistoryService rentTotalPlanHistoryService;
    @Autowired
    private RentTotalPlanMapper rentTotalPlanMapper;
    @Autowired
    private IShareMaterialApi materialApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentChangeTotalPlanService changeService;
    @Autowired
    private IRentTotalPlanService planService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "RENT_TOTAL_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentTotalPlanService service;
    private static final String BILL_TYPE = "BT220214000000002";

    @Override
    public RentTotalPlanVO insertOrUpdate(RentTotalPlanVO saveOrUpdateVO, Boolean isControl) {
        RentTotalPlanEntity entity = (RentTotalPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentTotalPlanEntity.class));
        if (!(isControl.booleanValue() || entity.getId() != null && entity.getId() != 0L || saveOrUpdateVO.getCode() != null)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && ((RentTotalPlanEntity)((Object)list.get(0))).getId() != null && !((RentTotalPlanEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            throw new BusinessException("\u9879\u76ee\u3010" + entity.getProjectName() + "\u3011\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u8ba1\u5212\uff01");
        }
        if (!isControl.booleanValue()) {
            this.service.saveOrUpdates(entity);
        }
        RentTotalPlanVO vo = (RentTotalPlanVO)BeanMapper.map((Object)((Object)entity), RentTotalPlanVO.class);
        if (!isControl.booleanValue()) {
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree((List)vo.getTotalPlanSubList()));
        }
        if (null == vo.getId() && isControl.booleanValue()) {
            vo.setId(Long.valueOf(IdWorker.getId()));
            List totalPlanSubList = vo.getTotalPlanSubList();
            for (RentTotalPlanSubVO rentTotalPlanSubVO : totalPlanSubList) {
                if (rentTotalPlanSubVO.getId() != null) continue;
                rentTotalPlanSubVO.setId(Long.valueOf(IdWorker.getId()));
            }
        }
        return vo;
    }

    @Override
    @Transactional
    public void saveOrUpdates(RentTotalPlanEntity entity) {
        entity.setChangeStatus(1);
        RentTotalPlanEntity planEntity = this.selectCode(entity.getCode());
        if (planEntity != null) {
            if (entity.getId() == null) {
                throw new BusinessException("\u8ba1\u5212\u7f16\u7801\u91cd\u590d:" + entity.getCode());
            }
            if (!entity.getId().equals(planEntity.getId())) {
                throw new BusinessException("\u8ba1\u5212\u7f16\u7801\u91cd\u590d:" + entity.getCode());
            }
        }
        this.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())) {
            this.saveOrUpdateChild(entity);
        }
        ExecutionVO executionVO = this.targetCost(entity);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
        }
    }

    @Override
    public void delByPlanId(Long pid) {
        this.rentTotalPlanMapper.delByPlanId(pid);
    }

    @Override
    public void test() {
        this.logger.info("--------------\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\uff0c\u5904\u7406\u4e1a\u52a1");
        Long id = 557254573766099013L;
        RentChangeTotalPlanEntity entity = (RentChangeTotalPlanEntity)((Object)this.changeService.selectById(id));
        List<RentChangeTotalPlanSubEntity> subEntityList = entity.getTotalPlanSubList();
        RentTotalPlanEntity contractEntity = (RentTotalPlanEntity)((Object)this.planService.selectById(entity.getTotalId()));
        this.logger.info("--------------\u540c\u6b65\u539f\u59cb\u603b\u8ba1\u5212\u5230\u8bb0\u5f55\u8868");
        this.logger.info("--------------\u540c\u6b65\u539f\u59cb\u603b\u8ba1\u5212\u6e05\u5355\u5230\u8bb0\u5f55\u8868");
        List<RentTotalPlanSubEntity> checkList = contractEntity.getTotalPlanSubList();
        if (null == checkList || checkList.size() > 0) {
            // empty if block
        }
        RentTotalPlanEntity newEntity = (RentTotalPlanEntity)((Object)BeanMapper.map((Object)((Object)entity), RentTotalPlanEntity.class));
        newEntity.setId(contractEntity.getId());
        newEntity.setBaseMny(contractEntity.getBaseMny());
        newEntity.setChangingMny(null);
        newEntity.setChangeStatus(3);
        newEntity.setChangeCode(contractEntity.getChangeCode());
        newEntity.setChangeId(contractEntity.getChangeId());
        newEntity.setBillState(contractEntity.getBillState());
        newEntity.setCreateTime(contractEntity.getCreateTime());
        newEntity.setVersion(contractEntity.getVersion());
        newEntity.setTotalPlanSubList(null);
        this.logger.info("--------------\u53d8\u66f4\u603b\u8ba1\u5212\u56de\u5199\u5230\u539f\u59cb\u603b\u8ba1\u5212");
        this.planService.saveOrUpdate((Object)newEntity);
        this.logger.info("--------------\u53d8\u66f4\u603b\u8ba1\u5212\u6e05\u5355\u56de\u5199\u5230\u539f\u59cb\u603b\u8ba1\u5212\u6e05\u5355");
        this.planService.delByPlanId(contractEntity.getId());
        if (CollectionUtils.isNotEmpty(subEntityList)) {
            List detailEntitys = BeanMapper.mapList(subEntityList, RentTotalPlanSubEntity.class);
            for (RentTotalPlanSubEntity detailEntity : detailEntitys) {
                detailEntity.setPid(entity.getTotalId());
            }
            this.rentTotalPlanSubService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
        }
        this.logger.info("--------------\u5904\u7406\u603b\u8ba1\u5212\u53d8\u66f4\u5355");
        this.changeService.saveOrUpdate((Object)entity, false);
        this.logger.info("--------------\u5904\u7406\u53d8\u66f4\u9644\u4ef6");
    }

    @Override
    public void delete(List<RentTotalPlanVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (RentTotalPlanVO rentTotalPlanVO : vos) {
                RentTotalPlanEntity rentTotalPlanEntity = (RentTotalPlanEntity)((Object)super.selectById((Serializable)rentTotalPlanVO.getId()));
                ExecutionVO executionVO = this.targetCost(rentTotalPlanEntity);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25" + response.getMsg());
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Transactional
    public void saveOrUpdateChild(RentTotalPlanEntity entity) {
        List<RentTotalPlanSubEntity> listbs = entity.getTotalPlanSubList();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (RentTotalPlanSubEntity cdEntity : listbs) {
            if (cdEntity.getParentId() != 999L) continue;
            idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
        }
        for (RentTotalPlanSubEntity cdEntity : listbs) {
            if (!cdEntity.getParentId().equals(999L)) {
                Long parentId = (Long)idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null ? parentId : entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());
                continue;
            }
            cdEntity.setTid(cdEntity.getId());
        }
        this.rentTotalPlanSubService.saveOrUpdateBatch(listbs, listbs.size(), false);
    }

    public RentTotalPlanEntity selectCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.rentTotalPlanMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (RentTotalPlanEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public ExecutionVO targetCost(RentTotalPlanEntity entity) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u603b\u8ba1\u5212.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setLinkUrl(this.baseHost + "ejc-proequipment-frontend/#/totalPlan/card?id=" + entity.getId());
        totalVO.setBillDate(entity.getOrganizationDate().toString());
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (RentTotalPlanSubEntity rentTotalPlanSubEntity : entity.getTotalPlanSubList()) {
            checkMoney = checkMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            checkTaxMoney = checkTaxMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(rentTotalPlanSubEntity.getId());
            detailExecutionVO.setSourceBillId(entity.getId());
            detailExecutionVO.setCategoryId(rentTotalPlanSubEntity.getEquipmentTypeId());
            detailExecutionVO.setCategoryName(rentTotalPlanSubEntity.getEquipmentTypeName());
            detailExecutionVO.setCode(rentTotalPlanSubEntity.getEquipmentCode());
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            if (rentTotalPlanSubEntity.getEquipmentId() == null) {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentTypeId());
            } else {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentId());
            }
            detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
            detailExecutionVO.setName(rentTotalPlanSubEntity.getEquipmentName());
            detailExecutionVO.setUnitName(rentTotalPlanSubEntity.getMeteringUnit());
            detailExecutionVO.setSpec(rentTotalPlanSubEntity.getSpecs());
            detailExecutionVO.setNum(rentTotalPlanSubEntity.getPlanTotal());
            detailExecutionVO.setMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailExecutionVO.setTaxMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(RentTotalPlanVO totalPlanVO) {
        RentTotalPlanVO contractVO1 = this.insertOrUpdate(totalPlanVO, true);
        ExecutionVO executionVO = this.targetCost((RentTotalPlanEntity)((Object)BeanMapper.map((Object)contractVO1, RentTotalPlanEntity.class)));
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentTotalPlanVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.targetCost((RentTotalPlanEntity)((Object)BeanMapper.map((Object)contractVO, RentTotalPlanEntity.class)));
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public RentTotalPlanVO queryDetail(Long id) {
        RentTotalPlanEntity entity = (RentTotalPlanEntity)((Object)this.service.selectById(id));
        RentTotalPlanVO vo = (RentTotalPlanVO)BeanMapper.map((Object)((Object)entity), RentTotalPlanVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())) {
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree((List)vo.getTotalPlanSubList()));
        }
        return vo;
    }

    @Override
    public void syncCost(Long id) {
        QueryWrapper rentPlanChangeQueryWrapper = new QueryWrapper();
        ((QueryWrapper)rentPlanChangeQueryWrapper.eq((Object)"total_id", (Object)id)).orderByDesc((Object)"create_time");
        List changeEntityList = this.changeService.list((Wrapper)rentPlanChangeQueryWrapper);
        ExecutionVO executionVO = new ExecutionVO();
        if (changeEntityList.size() > 0) {
            RentChangeTotalPlanEntity rentChangeTotalPlanEntity = (RentChangeTotalPlanEntity)((Object)this.changeService.selectById(((RentChangeTotalPlanEntity)((Object)changeEntityList.get(0))).getId()));
            executionVO = this.changeService.targetCost(rentChangeTotalPlanEntity, null);
        } else {
            RentTotalPlanEntity rentTotalPlanEntity = (RentTotalPlanEntity)((Object)this.service.selectById(id));
            executionVO = this.service.targetCost(rentTotalPlanEntity);
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
        }
    }

    @Override
    public List<RentChangeTotalPlanSubVO> queryChangeCompare(Long id) {
        RentChangeTotalPlanEntity rentChangeTotalPlanEntity = (RentChangeTotalPlanEntity)((Object)this.changeService.selectById(id));
        List<RentChangeTotalPlanSubEntity> totalPlanSubList = rentChangeTotalPlanEntity.getTotalPlanSubList();
        List rentChangeTotalPlanSubVOS = BeanMapper.mapList(totalPlanSubList, RentChangeTotalPlanSubVO.class);
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(RentTotalPlanHistoryEntity::getChangeId, (Object)id);
        RentTotalPlanHistoryEntity rentTotalPlanHistory = (RentTotalPlanHistoryEntity)((Object)this.rentTotalPlanHistoryService.getOne((Wrapper)lambda));
        RentTotalPlanHistoryEntity rentTotalPlanHistoryEntity = (RentTotalPlanHistoryEntity)((Object)this.rentTotalPlanHistoryService.selectById(rentTotalPlanHistory.getId()));
        List<RentTotalPlanHistorySubEntity> rentTotalPlanHistorySubList = rentTotalPlanHistoryEntity.getRentTotalPlanHistorySubList();
        Map hisMap = rentTotalPlanHistorySubList.stream().collect(Collectors.toMap(RentTotalPlanHistorySubEntity::getTotalBid, Function.identity()));
        for (RentChangeTotalPlanSubVO rentChangeTotalPlanSubVO : rentChangeTotalPlanSubVOS) {
            RentTotalPlanHistorySubEntity rentTotalPlanHistorySubEntity = (RentTotalPlanHistorySubEntity)((Object)hisMap.get(rentChangeTotalPlanSubVO.getSubDetailId()));
            if (rentTotalPlanHistorySubEntity == null) continue;
            rentChangeTotalPlanSubVO.setBcPlanTotal(rentTotalPlanHistorySubEntity.getPlanTotal());
            rentChangeTotalPlanSubVO.setBcTemporaryAmount(rentTotalPlanHistorySubEntity.getTemporaryAmount());
        }
        List rentChangeTotalPlanSubVOS1 = TreeNodeBUtil.buildTree((List)rentChangeTotalPlanSubVOS);
        return rentChangeTotalPlanSubVOS1;
    }
}

