package com.ejianc.business.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.bean.ContractRelieveEntity;
import com.ejianc.business.ac.enums.DraftTypeEnum;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.ac.service.IContractRelieveService;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.ac.vo.ContractRelieveVO;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("contractRelieve") 
public class ContractRelieveBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IContractRelieveService service;

	@Autowired
	private IContractService contractService;

	@Value("${common.env.base-host}")
	private String BaseHost;

	@Autowired
	private IExecutionApi executionApi;

	@Autowired
	private ITemplateCategoryApi templateCategoryApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractRelieveEntity entity = service.selectById(billId);
		if (entity != null) {
			// 已签章
			if (entity.getDraftType() == 2) {
				entity.setSignatureStatus("4");
				entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.已作废.getCode()));
				entity.setEffectiveDate(new Date());
				service.saveOrUpdate(entity, false);

				QueryParam param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
				List<ContractEntity> contractEntities = contractService.queryList(param, false);
				contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已作废.getCode());
				logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntities.get(0)));
				contractService.saveOrUpdate(contractEntities.get(0), false);
				// 推送合同池
				contractService.pushContract(BeanMapper.map(contractEntities.get(0), ContractVO.class));
			} else if (entity.getDraftType() == 1) {
				// 初始化成未签章
				entity.setSignatureStatus("1");
				logger.info("======终审审核完回调,初始化成未签章======,{}", JSONObject.toJSONString(entity));
				service.saveOrUpdate(entity, false);
			}
		}
		//目标成本推送
		String linkUrl;
		ContractEntity contractEntity = contractService.selectById(entity.getContractId());
		linkUrl = BaseHost+"ejc-proequipment-frontend/#/contractRelieve/card?id="+entity.getId();
		ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractRelieveVO.class),linkUrl,contractEntity.getContractType());
		logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
		CommonResponse<String> response = executionApi.aggPush(executionVO);
		if (!response.isSuccess()){
			throw new BusinessException("目标成本推送失败,"+response.getMsg());
		}

		return CommonResponse.success("合同解除终审审核完回调处理成功!");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		ContractRelieveEntity entity = service.selectById(billId);

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		// 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		if (DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType())
				&& !statusList.contains(entity.getSignatureStatus())) {
			return CommonResponse.error("合同解除" + (SignatureStatusEnum.已签章.getCode()
					.equals(entity.getSignatureStatus()) ? "已生效" : "已有签章流程") + "，不允许弃审!");
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.未签订.getCode()));
			service.saveOrUpdate(entity, false);
		}

		// 更新合同履约状态
		ContractEntity contractEntity = contractService.selectById(entity.getContractId());
		contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		// 重新推送合同池
		contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
		return CommonResponse.success("撤回前校验回调成功！");

	}
}
