package com.ejianc.business.order.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.SupplierSignStatusEnum;
import com.ejianc.business.appearance.bean.AppearanceEntity;
import com.ejianc.business.appearance.bean.AppearanceSubEntity;
import com.ejianc.business.appearance.service.IAppearanceService;
import com.ejianc.business.appearance.service.impl.AppearanceServiceImpl;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.order.bean.RentOrderDetailEntity;
import com.ejianc.business.order.bean.RentOrderEntity;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.order.enums.StatusTypeEnum;
import com.ejianc.business.order.mapper.RentOrderMapper;
import com.ejianc.business.order.service.IRentOrderService;
import com.ejianc.business.order.service.impl.RentOrderServiceImpl;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.service.impl.*;
import com.ejianc.business.rent.vo.RentAcceptanceVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.utils.RentEntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.models.auth.In;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/api/proequipment/")
public class RentReceiptsApi {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRentContractService service;

    @Autowired
    private IRentAcceptanceService checkService;

    @Autowired
    private IRentEquipmentStartService startService;

    @Autowired
    private IRentEquipmentStopService stopService;

    @Autowired
    private IRentSettlementService settleService;

    @Autowired
    private IRentRentalService rentalService;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private RentSettlementBpmServiceImpl settleBpmService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRentOrderService orderService;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private RentOrderMapper mapper;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAppearanceService appearanceService;
    @Autowired
    private IRentParameterService parameterService;


    /**
     * 内租合同
     * @param json,type
     * @return
     */
    @PostMapping(value = "/receiptsSync")
    public CommonResponse<String> receiptsSync(@RequestBody JSONObject json,@RequestParam("type") String type){
        String msg = "单据已经进行过同步操作，请勿重复操作！";
        List<RentParameterEntity> parameterList = new ArrayList<>();
        switch (RentReceiptsEnum.getEnumByName(type)) {
            case 租赁订单:
                orderSync(json);
                break;
            case 验收单:
                RentAcceptanceVO orderVO = JSON.parseObject(json.toJSONString(),RentAcceptanceVO.class);
                RentAcceptanceEntity rentAcceptanceEntity = BeanMapper.map(orderVO,RentAcceptanceEntity.class);
                rentAcceptanceEntity.setRentAcceptanceSubList(BeanMapper.mapList(orderVO.getRentAcceptanceSubList(), RentAcceptanceSubEntity.class));
                RentAcceptanceEntity data = RentEntityUtil.selectOneService("id", rentAcceptanceEntity.getId(),  RentAcceptanceServiceImpl.class);
                if(null != data) {
                    return CommonResponse.error(msg);
                }
                rentAcceptanceEntity.setCheckState(1);//默认直接验收
                rentAcceptanceEntity.setRentType("1");
                rentAcceptanceEntity.setCommitDate(new Date());
                checkService.saveOrUpdate(rentAcceptanceEntity,false);
                RentContractEntity contractEntity = service.selectById(rentAcceptanceEntity.getContractId());

                for (RentAcceptanceSubEntity e : rentAcceptanceEntity.getRentAcceptanceSubList()) {
                    RentParameterEntity parameter = new RentParameterEntity();
                    // 验收信息
                    parameter.setContractId(rentAcceptanceEntity.getContractId());//合同id
                    parameter.setContractName(rentAcceptanceEntity.getContractName()); // 合同名称
                    parameter.setEngineeringId(rentAcceptanceEntity.getEngineeringId()); // 工程id
                    parameter.setEngineeringName(rentAcceptanceEntity.getEngineeringName()); // 工程名称
                    parameter.setSupplierId(rentAcceptanceEntity.getSupplierId()); // 供应商id
                    parameter.setSupplierName(rentAcceptanceEntity.getSupplierName()); // 供应商名称
                    parameter.setProjectId(rentAcceptanceEntity.getProjectId()); // 项目id
                    parameter.setProjectCode(rentAcceptanceEntity.getProjectCode()); // 项目code
                    parameter.setProjectName(rentAcceptanceEntity.getProjectName()); // 项目名称
                    parameter.setAcceptanceId(rentAcceptanceEntity.getId()); // 验收单id
                    parameter.setAcceptanceDate(rentAcceptanceEntity.getAcceptanceDate()); // 验收日期
                    parameter.setSourceId(rentAcceptanceEntity.getId()); // 来源id
                    // 合同信息
                    parameter.setOrgId(contractEntity.getOrgId()); // 组织id
                    parameter.setOrgName(contractEntity.getOrgName()); // 组织名称
                    parameter.setParentOrgId(contractEntity.getParentOrgId());
                    parameter.setParentOrgCode(contractEntity.getParentOrgCode());
                    parameter.setParentOrgName(contractEntity.getParentOrgName());
                    parameter.setRentHarborType(contractEntity.getRentHarborType().equals("内租") ? 1:2);
                    // 设备信息
                    parameter.setFactoryCode(e.getFactoryCode()); // 设备出厂编码
                    parameter.setCategoryId(e.getCategoryId()); // 设备类别id
                    parameter.setCategoryName(e.getCategoryName()); // 设备类别名称
                    parameter.setSpec(e.getSpecs()); // 规格型号
                    parameter.setUnitName(e.getUnitName()); // 计量单位

                    parameter.setStartDate(rentAcceptanceEntity.getAcceptanceDate());

                    parameter.setPlanIntoDate(e.getPlanIntoDate()); // 计划进厂日期
                    parameter.setPlanOutDate(e.getPlanOutDate()); // 计划出厂日期
                    parameter.setProductionManufactor(e.getProductionManufactor()); // 生产厂家
                    parameter.setMemo(e.getMemo()); // 备注
                    parameter.setEquipmentCode(e.getEquipmentCode()); // 设备编号
                    parameter.setEquipmentId(e.getEquipmentId()); // 设备id
                    parameter.setName(e.getName()); // 设备id
                    parameter.setNum(e.getNum());
                    parameter.setRentNum(e.getNum()); // 租赁数量
                    parameter.setRentTypeId(e.getRentTypeId()); // 租赁方式id
                    parameter.setRentTypeName(e.getRentTypeName()); // 租赁方式名称
                    parameter.setAcceptanceDetailId(e.getId()); // 验收单明细id
                    parameter.setEquipmentName(e.getName()); // 设备名称
                    parameter.setPrice(e.getPrice()); // 有税单价
                    parameter.setNotTaxPrice(e.getNotTaxPrice()); // 无税单价
                    if(rentAcceptanceEntity.getEntranceRentFlag() ==1){
                        parameter.setMeterRentDate(e.getMeterRentDate()); // 计租日期
                    }else {
                        parameter.setMeterRentDate(null); // 计租日期
                    }
                    parameter.setOperationDate(new Date()); // 操作日期
                    parameter.setEquipmentState(RentEquipmentStateEnum.待启用.getCode());
                    parameter.setQuantitiesNum(e.getQuantitiesNum() == null ? BigDecimal.ZERO : e.getQuantitiesNum());
                    parameterService.saveOrUpdate(parameter,false);
                }

                break;
            case 启用单:
                RentEquipmentStartEntity startEntity = JSON.parseObject(json.toJSONString(), RentEquipmentStartEntity.class);
                RentEquipmentStartEntity startData = RentEntityUtil.selectOneService("id", startEntity.getId(), RentEquipmentStartServiceImpl.class);
                if(null != startData) {
                    return CommonResponse.error(msg);
                }
                startEntity.setRentType("1");
                startEntity.setType(1);
                startService.saveOrUpdate(startEntity,false);
                //更新台账设备状态
                List<RentEquipmentStartSubEntity> startSubEntityList = startEntity.getRentEquipmentStartSubList();
                for (RentEquipmentStartSubEntity subEntity : startSubEntityList) {
                    // 主表赋值
                    RentParameterEntity parameterEntity = new RentParameterEntity();
                    parameterEntity.setId(subEntity.getSourceId());
                    parameterEntity.setStartDate(startEntity.getTypeDate());
                    parameterEntity.setOperationDate(new Date());
                    parameterEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());//启动状态
                    if (EntranceRentFlagEnum.是.getCode().equals(startEntity.getEntranceRentFlag())){
                        //初次进场启用   需要把计租日期赋值
                        parameterEntity.setMeterRentDate(subEntity.getTypeDate());
                    }
                    parameterList.add(parameterEntity);
                }
                logger.info("推送台账数据parameterList：{}", JSONObject.toJSONString(parameterList));
                parameterService.changeParameter(parameterList, RentParameterTypeEnum.启用单.getCode());
                break;
            case 停用单:
                RentEquipmentStopEntity stopEntity = JSON.parseObject(json.toJSONString(), RentEquipmentStopEntity.class);
                RentEquipmentStopEntity stopData = RentEntityUtil.selectOneService("id", stopEntity.getId(), RentEquipmentStopServiceImpl.class);
                if(null != stopData) {
                    return CommonResponse.error(msg);
                }
                stopEntity.setRentType("1");
                stopEntity.setType(0);
                stopService.saveOrUpdate(stopEntity,false);

                //更新台账状态
                List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
                //是否退场停用   1-是  2-否
                //停租   1，直接插入一条退场数据
                for(RentEquipmentStopSubEntity subEntity:subEntityList) {
                    // 主表赋值
                    RentParameterEntity parameterEntity = new RentParameterEntity();
                    parameterEntity.setId(subEntity.getSourceId());
                    parameterEntity.setStopDate(subEntity.getTypeDate());
                    parameterEntity.setOperationDate(new Date());
                    if (EntranceRentFlagEnum.是.getCode().equals(stopEntity.getEntranceRentFlag())){
                        parameterEntity.setEquipmentState(RentEquipmentStateEnum.停租.getCode());
                    }else {
                        parameterEntity.setEquipmentState(RentEquipmentStateEnum.停用.getCode());//启动状态
                    }
                    parameterList.add(parameterEntity);
                }
                logger.info("推送台账数据parameterList：{}", JSONObject.toJSONString(parameterList));
                parameterService.changeParameter(parameterList, RentParameterTypeEnum.停用单.getCode());
                break;

            case 租赁合同结算单:
                RentSettlementEntity settleEntity= JSON.parseObject(json.toJSONString(), RentSettlementEntity.class);
                RentSettlementEntity settleData = RentEntityUtil.selectOneService("id", settleEntity.getId(), RentSettlementServiceImpl.class);
                if(null != settleData) {
                    return CommonResponse.error(msg);
                }
                UserContext userContext = sessionManager.getUserContext();
             /*   settleEntity.setCommitDate(new Date());
                settleEntity.setCommitUserCode(userContext.getUserCode());
                settleEntity.setCommitUserName(userContext.getUserName());*/
                // 推送结算池
                Boolean poolRes = settleService.pushSettleToPool(BeanMapper.map(settleEntity, RentSettlementVO.class));
                if (Boolean.TRUE.equals(poolRes)){
                    settleEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                }else {
                    settleEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
                }
                // 更新合同池操作
                settleService.updateContractPoolSettle(BeanMapper.map(settleEntity, RentSettlementVO.class),true);

                settleService.saveOrUpdate(settleEntity,false);

                //租金占用
                if(CollectionUtils.isNotEmpty(settleEntity.getRentSettlementRentalList())){
                    List<RentSettlementRentalEntity> rentalList = settleEntity.getRentSettlementRentalList();
                    List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                    rentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.已结算.getCode());
                }

                // 回写合同状态
                if (Objects.equals(settleEntity.getSettlementType(), "1")) {
                    LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(RentContractEntity::getContractPerformanceState, ContractPerformanceStateEnum.已终止.getStateCode());
                    updateWrapper.eq(RentContractEntity::getId, settleEntity.getContractId());
                    service.update(updateWrapper);
                    // 最终结算推送目标成本
                    ExecutionVO executionVO = settleService.targetCost(settleEntity);
                    CommonResponse<String> response = executionApi.aggPush(executionVO);
                    if (!response.isSuccess()){
                        logger.error("推送目标成本失败: , {}", response.getMsg());
                        throw new BusinessException(response.getMsg());
                    }
                }
                logger.info("推送实际成本---");
                settleService.costPush(settleEntity);
                //回写引用单据结算状态
                //settleBpmService.writeSettleFlag(settleEntity, 1);
                break;
            case 租金计算单:
                RentRentalEntity rentalEntity= JSON.parseObject(json.toJSONString(), RentRentalEntity.class);
                logger.info("接收到租金计算单：{}", JSONObject.toJSONString(rentalEntity));
                RentRentalEntity rentalData = RentEntityUtil.selectOneService("id", rentalEntity.getId(), RentRentalServiceImpl.class);
                if(null != rentalData) {
                    return CommonResponse.error(msg);
                }
                rentalService.saveOrUpdate(rentalEntity,false);
                logger.info("租金计算推送实际成本---");
                rentalService.costPush(rentalEntity);
                break;
            case 退场单:
                AppearanceEntity appearanceEntity = JSON.parseObject(json.toJSONString(), AppearanceEntity.class);
                AppearanceEntity appearanceData = RentEntityUtil.selectOneService("id", appearanceEntity.getId(), AppearanceServiceImpl.class);
                if(null != appearanceData) {
                    return CommonResponse.error(msg);
                }

                appearanceEntity.setRentType("1");
                appearanceService.saveOrUpdate(appearanceEntity,false);
                for (AppearanceSubEntity subEntity : appearanceEntity.getAppearanceSubList()) {
                    // 主表赋值
                    RentParameterEntity parameterEntity = new RentParameterEntity();
                    parameterEntity.setId(subEntity.getSourceId());
                    parameterEntity.setOutDate(appearanceEntity.getAppearanceDate());
                    parameterEntity.setOperationDate(new Date());
                    parameterEntity.setEquipmentState(RentEquipmentStateEnum.退场.getCode());//启动状态// 处理子表
                    if(subEntity.getState() !=6){
                        List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
                        RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                        detailEntity.setSourceType(RentParameterTypeEnum.退场单.getCode());
                        detailEntity.setSourceId(appearanceEntity.getId());
                        detailEntity.setOperationDate(appearanceEntity.getRentEndDate());
                        detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
                        detailEntity.setParameterId(subEntity.getSourceId());
                        parameterDetailList.add(detailEntity);

                        parameterEntity.setRentParameterDetailList(parameterDetailList);
                        parameterList.add(parameterEntity);
                    }
                }
                parameterService.changeParameter(parameterList, RentParameterTypeEnum.停用单.getCode());
                break;

        }
        return CommonResponse.success("同步成功！");
    }

    /**
     * 单据撤回删除
     *
     * @param id,type
     * @return
     */
    @PostMapping(value = "/delReceipts")
    public CommonResponse<String> delReceipts(@RequestParam("id") Long id,@RequestParam("type") String type){
        String msg = "操作失败,未查到单据!";
        switch (RentReceiptsEnum.getEnumByName(type)) {
             case 验收单:
                 RentAcceptanceEntity data = RentEntityUtil.selectOneService("id", id, RentAcceptanceServiceImpl.class);
                if(null == data) {
                    return CommonResponse.error(msg);
                }
                checkService.delById(id);
                break;
            case 启用单:
                RentEquipmentStartEntity startData = RentEntityUtil.selectOneService("id",id, RentEquipmentStartServiceImpl.class);
                if(null == startData) {
                    return CommonResponse.error(msg);
                }
                startService.delById(id);
                break;
            case 停用单:
                RentEquipmentStopEntity stopData = RentEntityUtil.selectOneService("id", id, RentEquipmentStopServiceImpl.class);
                if(null == stopData) {
                    return CommonResponse.error(msg);
                }
                stopService.delById(id);
                break;
            case 退场单:
                AppearanceEntity appearanceEntity = RentEntityUtil.selectOneService("id",id, AppearanceServiceImpl.class);
                if(null == appearanceEntity) {
                    return CommonResponse.error(msg);
                }
                appearanceService.delById(id);
                break;
            case 租赁合同结算单:
                RentSettlementEntity settleData = RentEntityUtil.selectOneService("id", id, RentSettlementServiceImpl.class);
                if(null == settleData) {
                    return CommonResponse.error(msg);
                }
                // 从结算池中删除数据
                Boolean unPushRes = settleService.delSettleFromPool(settleData.getId());
                if (Boolean.TRUE.equals(unPushRes)) {
                    settleData.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
                } else {
                    throw new BusinessException("结算单从结算池删除失败!");
                }
                // 回写合同状态
                LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(RentContractEntity::getContractPerformanceState, ContractPerformanceStateEnum.履约中.getStateCode());
                updateWrapper.eq(RentContractEntity::getId, settleData.getContractId());
                service.update(updateWrapper);
                // 更新合同池操作
                settleService.updateContractPoolSettle(BeanMapper.map(settleData, RentSettlementVO.class), false);

                //租金占用
                if(CollectionUtils.isNotEmpty(settleData.getRentSettlementRentalList())){
                    List<RentSettlementRentalEntity> rentalList = settleData.getRentSettlementRentalList();
                    List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                    rentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.未结算.getCode());
                }

                // 删除目标成本
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionVO = settleService.targetCost(settleData);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本删除失败！");
                }
                logger.info("删除实际成本---");
                settleService.delById(id);
                break;
            case 租金计算单:
                RentRentalEntity rentalEntity = RentEntityUtil.selectOneService("id", id, RentRentalServiceImpl.class);
                logger.info("查到租金计算单：{}", JSONObject.toJSONString(rentalEntity));
                if(null == rentalEntity) {
                    return CommonResponse.error(msg);
                }

                // 删除实际成本
                logger.info("删除成本中心之前的数据-Id---{}",id);
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(id);
                logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
                logger.info("删除租金计算单---");
                rentalService.delRentalById(id);
                break;
        }
        return CommonResponse.success("删除成功!");
    }


    /**
     * 设备公司推送单据修改台账中设备状态
     * @param jsonArray
     * @param updateStartFlag：是否初次进场启用单撤回
     * @return
     */
    @PostMapping(value = "/updateEquipmentState")
    public CommonResponse<String> updateEquipmentState(@RequestBody JSONArray jsonArray, @RequestParam("updateStartFlag") Boolean updateStartFlag){
        List<RentParameterVO> rentParameterList = jsonArray.toJavaList(RentParameterVO.class);
        if (CollectionUtils.isEmpty(rentParameterList)){
            throw new BusinessException("传参不能为空！");
        }
        logger.info("获取参数rentParameterList：{}", JSONObject.toJSONString(rentParameterList));
        Map<String, Integer> equipmentStateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getEquipmentState, (k1, k2) -> k2));
        Map<String, Date> equipmentStartDateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getStartDate, (k1, k2) -> k2));
        Map<String, Date> equipmentStopDateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getStopDate, (k1, k2) -> k2));
        Map<String, Date> equipmentOutDateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getOutDate, (k1, k2) -> k2));
        List<String> factoryCodeList = rentParameterList.stream().map(RentParameterVO::getFactoryCode).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("factory_code", new Parameter(QueryParam.IN, factoryCodeList));
        List<RentParameterEntity> rentParameterEntityList = parameterService.queryList(queryParam);
        if (CollectionUtils.isEmpty(rentParameterEntityList)){
            throw new BusinessException("操作失败,未查到对应单据！");
        }
        logger.info("查询到台账信息rentParameterList：{}", JSONObject.toJSONString(rentParameterEntityList));
        for (RentParameterEntity rentParameterEntity : rentParameterEntityList) {
            if (null != equipmentStateMap.get(rentParameterEntity.getFactoryCode())){
                rentParameterEntity.setEquipmentState(equipmentStateMap.get(rentParameterEntity.getFactoryCode()));
                rentParameterEntity.setStartDate(equipmentStartDateMap.get(rentParameterEntity.getFactoryCode()));
                rentParameterEntity.setStopDate(equipmentStopDateMap.get(rentParameterEntity.getFactoryCode()));
                rentParameterEntity.setOutDate(equipmentOutDateMap.get(rentParameterEntity.getFactoryCode()));
                rentParameterEntity.setOperationDate(new Date());
                //如果是 初次进场启用单撤回   1，更新主表状态为待启用，计租日期为空，操作时间为最新
                if (updateStartFlag){
                    rentParameterEntity.setMeterRentDate(null);
                    rentParameterEntity.setStartDate(null);
                }
            }
        }
        parameterService.saveOrUpdateBatch(rentParameterEntityList, rentParameterEntityList.size(), false);
        return CommonResponse.success("修改成功!");
    }

    private void orderSync(JSONObject json){
        RentOrderEntity orderEntity = JSON.parseObject(json.toJSONString(),RentOrderEntity.class);
        RentOrderEntity orderData = RentEntityUtil.selectOneService("id", orderEntity.getId(), RentOrderServiceImpl.class);
        if(null != orderData) {
            List<RentOrderDetailEntity> list = orderEntity.getRentOrderDetailList();
            //全部接收或部分接收
            if (orderEntity.getReceiveState() ==1 || orderEntity.getReceiveState()==2){
                orderData.setReceiveState(orderEntity.getReceiveState());
                if (CollectionUtils.isNotEmpty(orderData.getRentOrderDetailList())){
                    //接收数量
                    Map<Long, RentOrderDetailEntity> collect = list.stream().collect(Collectors.toMap(RentOrderDetailEntity::getId, Function.identity(), (k1, k2) -> k2));
                    for (RentOrderDetailEntity detailEntity:orderData.getRentOrderDetailList()){
                        if (collect.get(detailEntity.getId())!=null){
                            RentOrderDetailEntity detail = collect.get(detailEntity.getId());
                            detailEntity.setReceiveNumsSum(detail.getReceiveNumsSum());
                        }
                    }
                }
            } else {
                //不予接收
                orderData.setReceiveReason(orderEntity.getReceiveReason());
                orderData.setReceiveState(orderEntity.getReceiveState());
            }
            orderService.saveOrUpdate(orderData,false);
        }
    }

    /**
     * 订单变更送货状态
     * @param jsonArray
     * @return
     *//*
    @PostMapping(value = "/orderChangeStatus")
    public CommonResponse<String> orderChangeStatus(@RequestBody JSONArray jsonArray) {
        List<OutRmatOrderVO> list = jsonArray.toJavaList(OutRmatOrderVO.class);
        //更新送货状态
        mapper.updateBatch(list);
        List<OutRmatOrderDetailVO> outList = new ArrayList<>();
        for (OutRmatOrderVO orderVO : list) {
            outList.addAll(orderVO.getOrderDetailList());
        }
        //更新子表送货量
        mapper.updateBatchByDetail(outList);
        return CommonResponse.success("回写成功");
    }*/

    /**
     * 回写辅料中心签字状态
     * @param id,type
     * @return
     */
    @GetMapping(value = "/writeBackSign")
    public CommonResponse<String> writeBackSign(@RequestParam(value = "id") String id,@RequestParam(value = "type") String type) {
        CommonResponse<UserVO> userResp = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(!userResp.isSuccess()) {
            logger.error("查询当前用户id-{},信息失败， {}", InvocationInfoProxy.getUserid(), userResp.getMsg());
            throw new BusinessException("查询当前用户信息失败!");
        }
        UserVO user = userResp.getData();
        Map<String,String> map = new HashMap<>();
        map.put("billId", id);
        map.put("supOperatorName", user.getUserName());
        map.put("supOperatorPhone", user.getUserMobile());
        map.put("supOperatorUserCode", user.getUserCode());
        map.put("supOperateTime", Long.toString(System.currentTimeMillis()));
        //Boolean flag = outRmatApi.updateBillSupSignSyncInfo(map,type).isSuccess();
        if (Boolean.FALSE.equals(true)){
            return CommonResponse.error("回写失败!");
        }else {
            switch (RentReceiptsEnum.getEnumBySourceName(type)) {
                case 验收单:
                    RentAcceptanceEntity entity = checkService.selectById(id);
                    entity.setSupOperateTime(new Date());
                    entity.setSupOperatorPhone(user.getUserMobile());
                    entity.setSupOperatorName(user.getUserName());
                    entity.setSupOperatorUserCode(user.getUserCode());
                    entity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    checkService.saveOrUpdate(entity,false);
                    break;
                case 启用单:
                    RentEquipmentStartEntity startEntity = startService.selectById(id);
                    startEntity.setSupOperateTime(new Date());
                    startEntity.setSupOperatorPhone(user.getUserMobile());
                    startEntity.setSupOperatorName(user.getUserName());
                    startEntity.setSupOperatorUserCode(user.getUserCode());
                    startEntity.setSignState(SupplierSignStatusEnum.乙方已签字.getCode());
                    startService.saveOrUpdate(startEntity,false);
                    break;
                case 停用单:
                    RentEquipmentStopEntity stopEntity = stopService.selectById(id);
                    stopEntity.setSupOperateTime(new Date());
                    stopEntity.setSupOperatorPhone(user.getUserMobile());
                    stopEntity.setSupOperatorName(user.getUserName());
                    stopEntity.setSupOperatorUserCode(user.getUserCode());
                    stopEntity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    stopService.saveOrUpdate(stopEntity,false);
                    break;

                default:
                    RentSettlementEntity settleEntity = settleService.selectById(id);
                    settleEntity.setSupOperateTime(new Date());
                    settleEntity.setSupOperatorPhone(user.getUserMobile());
                    settleEntity.setSupOperatorName(user.getUserName());
                    settleEntity.setSupOperatorUserCode(user.getUserCode());
                    settleEntity.setSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());
                    settleService.saveOrUpdate(settleEntity,false);
                    break;
            }
            signSync(id, RentReceiptsEnum.getEnumBySourceName(type).getCode(), RentReceiptsEnum.getEnumBySourceName(type).getFileType(), StatusTypeEnum.getEnumByName(type).getCode(),StatusTypeEnum.getEnumByName(type).getFileType());
        }
        return CommonResponse.success("回写成功!");
    }


    private void signSync(String id,String sourceBillType,String sourceBillSourceType,String targetBillType,String targetBillSourceType){
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                id, sourceBillType, sourceBillSourceType,
                id, targetBillType, targetBillSourceType);
        if(!response.isSuccess()) {
            throw new BusinessException("同步单据附件失败！");
        }
    }


    /*private JSONObject refTransform(JSONObject jsonObject){
        if(jsonObject.containsKey("rent_project_id")){
            jsonObject.put("project_id",jsonObject.get("rent_project_id"));
            jsonObject.remove("rent_project_id");
        }
        if(jsonObject.containsKey("rent_project_code")){
            jsonObject.put("project_code",jsonObject.get("rent_project_code"));
            jsonObject.remove("rent_project_code");
        }
        if(jsonObject.containsKey("rent_project_name")){
            jsonObject.put("project_name",jsonObject.get("rent_project_name"));
            jsonObject.remove("rent_project_name");
        }
        if(jsonObject.containsKey("rent_org_id")){
            jsonObject.put("org_id",jsonObject.get("rent_org_id"));
            jsonObject.remove("rent_org_id");
        }
        if(jsonObject.containsKey("rent_org_code")){
            jsonObject.put("org_code",jsonObject.get("rent_org_code"));
            jsonObject.remove("rent_org_code");
        }
        if(jsonObject.containsKey("rent_org_name")){
            jsonObject.put("org_name",jsonObject.get("rent_org_name"));
            jsonObject.remove("rent_org_name");
        }
        return jsonObject;
    }*/
}
