package com.ejianc.business.rent.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.rent.bean.RentTotalPlanSubEntity;
import com.ejianc.business.rent.service.IRentEquipmentPlanSubService;
import com.ejianc.business.rent.service.IRentTotalPlanSubService;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.service.IRentTotalPlanService;

/**
 * 租赁设备总计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentTotalPlan")
public class RentTotalPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RENT_TOTAL_PLAN";//此处需要根据实际修改

    @Autowired
    private IRentTotalPlanService service;

    @Autowired
    private SessionManager sessionManager;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IRentTotalPlanSubService rentTotalPlanSubService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentTotalPlanVO> saveOrUpdate(@RequestBody RentTotalPlanVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",  service.insertOrUpdate(saveOrUpdateVO,false));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentTotalPlanVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentTotalPlanVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentTotalPlanVO>> queryList(@RequestBody QueryParam param) {

        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");
        /** 模糊搜索配置字段示例 */
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            //** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("companyId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RentTotalPlanEntity> page = service.queryPage(param,false);
        IPage<RentTotalPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentTotalPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentTotalPlanEntity> list = service.queryList(param);
        List<RentTotalPlanVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list,RentTotalPlanVO.class);
            for (RentTotalPlanVO vo: voList){
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if(vo.getChangeStatus().equals(1)){
                    vo.setChangeStatusName("未变更");
                }else if( vo.getChangeStatus().equals(2)){
                    vo.setChangeStatusName("变更中");
                }else if( vo.getChangeStatus().equals(3)){
                    vo.setChangeStatusName("已变更");
                }

            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("rentTotalPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentTotalPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentTotalPlanSubRefVO>> refRentTotalPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             @RequestParam(required = false) String relyCondition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(!org.apache.commons.lang.StringUtils.isEmpty(relyCondition)){
            param.getParams().put("pid", new Parameter(QueryParam.EQ, relyCondition.split("=")[1]));
        }else {
            throw new BusinessException("请选择申请单！");
        }

        param.getParams().put("leafFlag", new Parameter(QueryParam.EQ, false));

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<RentTotalPlanSubEntity> page = rentTotalPlanSubService.queryPage(param,false);
        IPage<RentTotalPlanSubRefVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentTotalPlanSubRefVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentTotalPlanSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentTotalPlanSubRefVO>> refRentTotalPlanSubData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        Long projectId = null;

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
        }
        List<RentTotalPlanEntity> list = new ArrayList<>();

        if(projectId != null){
            QueryParam params = new QueryParam();
            params.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
            params.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
            list =service.queryList(params);
            param.getParams().put("leafFlag",new Parameter(QueryParam.EQ,false));
            param.getParams().put("pid",new Parameter(QueryParam.IN,list.stream().map(RentTotalPlanEntity::getId).collect(Collectors.toList())));
        }else{
            throw new BusinessException("请选择项目");
        }

        IPage<RentTotalPlanSubEntity> page = rentTotalPlanSubService.queryPage(param,false);
        IPage<RentTotalPlanSubRefVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentTotalPlanSubRefVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentPlanData", method = RequestMethod.GET)
    @ResponseBody
    public List<RentTotalPlanVO> refRentPlanData(@RequestParam(required = false) String searchText,
                                                    @RequestParam(required = false) String condition) {

        SimpleDateFormat sDateFormat=new SimpleDateFormat("yyyy-MM-dd");

        QueryParam params = new QueryParam();
        params.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        Long projectId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.getLong("projectId") != null){
                projectId = _con.getLong("projectId");
            }
            params.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        }
        List<RentTotalPlanEntity> dataList = service.queryList(params);
        List<RentTotalPlanVO> list = BeanMapper.mapList(dataList,RentTotalPlanVO.class);
        if (CollectionUtil.isNotEmpty(list)) {
            for (RentTotalPlanVO vo : list) {
                vo.setName(vo.getCode() + "-" + vo.getEmployeeName()+"-"+sDateFormat.format(vo.getCreateTime()));
            }
        }
        return list;
    }
    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody RentTotalPlanVO totalPlanVO) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(totalPlanVO));
    }
    @ApiOperation("同步目标成本接口")
    @RequestMapping(value = "/syncCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        service.syncCost(id);
        return CommonResponse.success("同步成功");
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public void test(){
        service.test();
    }
    /**
     * @Author yangst
     * @Description  查询变更对比
     * @param
     */
    @RequestMapping(value = "/queryChangeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentChangeTotalPlanSubVO>> queryChangeCompare(Long id) {
        List<RentChangeTotalPlanSubVO> list  = service.queryChangeCompare(id);
        return CommonResponse.success("查询转换数据成功！", list);
    }

}
