package com.ejianc.business.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.mapper.RentContractRecordMapper;
import com.ejianc.business.rent.mapper.RentContractRelieveMapper;
import com.ejianc.business.rent.service.IRentContractRelieveService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 租赁合同解除
 * 
 * @author generator
 * 
 */
@Service("rentContractRelieveService")
public class RentContractRelieveServiceImpl extends BaseServiceImpl<RentContractRelieveMapper, RentContractRelieveEntity> implements IRentContractRelieveService{
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IRentContractService rentContractService;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private RentContractRelieveMapper relieveService;
    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(RentContractRelieveEntity entity) {
        // 计算所有过程结算累计结算金额
        LambdaQueryWrapper<RentSettlementEntity> wrapper = new LambdaQueryWrapper<RentSettlementEntity>();
        wrapper.eq(RentSettlementEntity::getContractId, entity.getContractId());
        wrapper.eq(RentSettlementEntity::getSettlementType, "0");
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1,3));
        List<RentSettlementEntity> list = rentSettlementService.list(wrapper);

        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        RentContractEntity contractEntity = rentContractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BTC220314000000001");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getCompanyId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(baseHost + "ejc-proequipment-frontend/#/leaseContractContractRelieveCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;

    }

    @Override
    public void delById(Long id) {
        relieveService.delById(id);
    }
}
