package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.service.*;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;
import java.util.stream.Collectors;

@Service("rentEquipmentStart")
public class RentEquipmentStartBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentEquipmentStartService rentEquipmentStartService;
	@Autowired
	private IRentParameterService rentParameterService;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IRentParameterDetailService rentParameterDetailService;
	@Autowired
	private IProSupplierApi proSupplierApi;
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	@Autowired
	private IRentSettlementService rentSettlementService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_TYPE = "BT220221000000003";//已调整
	private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";

	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
	private final String OPERATE = "RENT-PROEQUIPMENT-START";

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RentEquipmentStartEntity entity =rentEquipmentStartService.selectById(billId);
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			//推送供方
			//对单据进行加锁
			//CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
			//if (!ejcCloudSystemCode.isSuccess()) {
			//	throw new BusinessException("获取当前系统编码失败！");
			//}
			//Map<String,Object> map = new HashMap<>();
			//map.put("sourceId",billId);
			//map.put("systemId",ejcCloudSystemCode.getData());
			//String dataInfo = JSONObject.toJSONString(map);
			//Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
			//		entity.getSupplierId().toString(),OPERATE,BILL_TYPE);
			//if (!updateSupplierStatus){
			//	throw new BusinessException("单据推送失败！");
			//}
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			rentEquipmentStartService.saveOrUpdate(entity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentEquipmentStartEntity startEntity = rentEquipmentStartService.selectById(billId);
		Boolean entranceRentFlag = false;
		if (EntranceRentFlagEnum.是.getCode().equals(startEntity.getEntranceRentFlag())){
			entranceRentFlag = true;
		}
		List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
		List<RentParameterEntity> parameterList = new ArrayList<>();
		for (RentEquipmentStartSubEntity subEntity : subEntityList) {
			// 主表赋值
			RentParameterEntity parameterEntity = new RentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setStartDate(subEntity.getTypeDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());//启动状态

			if (!entranceRentFlag){
				// 处理子表
				List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
				RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
				detailEntity.setSourceType(RentParameterTypeEnum.启用单.getCode());
				detailEntity.setSourceId(startEntity.getId());
				detailEntity.setOperationDate(subEntity.getTypeDate());
				detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
				detailEntity.setParameterId(subEntity.getSourceId());
				parameterDetailList.add(detailEntity);

				parameterEntity.setRentParameterDetailList(parameterDetailList);
			}else {
				//初次进场启用   需要把计租日期赋值
				parameterEntity.setMeterRentDate(subEntity.getTypeDate());
				parameterEntity.setOperationDate(new Date());
                parameterEntity.setStartDate(new Date());
			}
			parameterList.add(parameterEntity);
		}
		if (entranceRentFlag){
			//是否为进场启用：
			//是：选择待启用的设备，提交时更新台账第一条数据的操作日期
			//更新租出台账子表操作时间
			List<Long> parameterIdList = subEntityList.stream().map(RentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
			Map<Long, Date> startSubDateMap = subEntityList.stream().collect(Collectors.toMap(RentEquipmentStartSubEntity::getSourceId, RentEquipmentStartSubEntity::getTypeDate, (key1, key2) -> key2));
			logger.info("获取设备子表集合：{}", JSONObject.toJSONString(startSubDateMap));
			logger.info("获取台账设备id集合：{}", JSONObject.toJSONString(parameterIdList));
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("parameterId", new Parameter(QueryParam.IN, parameterIdList));
			List<RentParameterDetailEntity> detailEntityList = rentParameterDetailService.queryList(queryParam);
			logger.info("获取台账设备子表集合：{}", JSONObject.toJSONString(detailEntityList));
			if (CollectionUtils.isNotEmpty(detailEntityList)){
				for (RentParameterDetailEntity detailEntity : detailEntityList) {
					if (startSubDateMap.containsKey(detailEntity.getParameterId())){
						detailEntity.setOperationDate(startSubDateMap.get(detailEntity.getParameterId()));
					}
				}
			}
			rentParameterDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
		}

		logger.info("推送台账数据parameterList：{}", JSONObject.toJSONString(parameterList));
		rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.启用单.getCode());

		//推送供方验收单处理
//		PushRentEquipmentStartVO supplierPushCheckVO = BeanMapper.map(startEntity, PushRentEquipmentStartVO.class);
//		supplierPushCheckVO.setSourceId(startEntity.getId());
//		List<PushRentEquipmentStartSubVO> pushRentEquipmentStartSubVOS = BeanMapper.mapList(startEntity.getRentEquipmentStartSubList(), PushRentEquipmentStartSubVO.class);
//
//		for (PushRentEquipmentStartSubVO supplierPushCheckDetailVO : pushRentEquipmentStartSubVOS){
//			supplierPushCheckDetailVO.setSourceId(startEntity.getId());
//			supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
//			supplierPushCheckDetailVO.setId(null);
//		}
//		supplierPushCheckVO.setEquipmentStartDetailList(pushRentEquipmentStartSubVOS);
//		//设置单据当前系统信息
//		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//		if (!ejcCloudSystemCode.isSuccess()) {
//			logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
//		}
//		else {
//			//设置当前系统ID
//			supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
//			String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
//			//查询该单据是否支持协同分享，则向供方协同服务推送该单据
//			CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
//			if (!cooperateResp.isSuccess()) {
//				logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
//			}
//			else {
//				boolean b = rentAcceptanceService.pushBillToSupCenter(dataInfo, startEntity.getSupplierId(),
//						startEntity.getId(), BILL_TYPE, cooperateResp.getData(), PUSH_SAVE_URL);
//				if (!b) {
//					logger.error("推送供方失败！单据信息：{}", dataInfo);
//				}
//				else {
//					startEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//				}
//			}
//		}

		rentEquipmentStartService.updateById(startEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentEquipmentStartEntity startEntity =rentEquipmentStartService.selectById(billId);
		if(startEntity.getRentType().equals("1")){
			return CommonResponse.error("内租合同不支持撤回");
		}
//		EquipmentNewDateVO equipmentNewDateVO =rentParameterService.selectAbandonDate(startEntity.getContractId(),startEntity.getTypeDate());
//		if(equipmentNewDateVO != null){
//			if(!startEntity.getId().equals(equipmentNewDateVO.getId())){
//				return CommonResponse.error("弃审失败:请先弃审设备" + equipmentNewDateVO.getType() + "单据在弃审本单据");
//			}
//		}
		List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
		RentAcceptanceEntity rentAcceptanceEntity = null;
		for(RentEquipmentStartSubEntity subEntity:subEntityList) {
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("parameterId", new Parameter(QueryParam.EQ, subEntity.getSourceId()));
			queryParam.getOrderMap().put("createTime", QueryParam.DESC);
			List<RentParameterDetailEntity> detailEntityList = rentParameterDetailService.queryList(queryParam, false);
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(detailEntityList)) {
				RentParameterDetailEntity detailEntity = detailEntityList.get(0);
				if(null != detailEntity.getOperationDate() && !billId.equals(detailEntity.getSourceId())){
					if(EntranceRentFlagEnum.是.getCode().equals(startEntity.getEntranceRentFlag())) {
						//进场即计租时，判断当前最后一次操作记录是否是来源于验收单，如果来源于验收单，则允许撤回
						rentAcceptanceEntity = rentAcceptanceService.selectById(detailEntity.getSourceId());
						if(null != rentAcceptanceEntity) {
							return CommonResponse.success("弃审校验成功！");
						}
					}
					return CommonResponse.error("弃审失败:该单据已存在下游单据或已做租金计算，请检查");
				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//反向操作
		RentEquipmentStartEntity startEntity = rentEquipmentStartService.selectById(billId);
		QueryParam settlementQueryParam = new QueryParam();
		settlementQueryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, startEntity.getContractId()));
		List<RentSettlementEntity> outRentSettlementEntityList = rentSettlementService.queryList(settlementQueryParam);
		if (org.apache.commons.collections.CollectionUtils.isNotEmpty(outRentSettlementEntityList)){
			return CommonResponse.error("当前单据的设备，已被下游结算单引用，不能撤回！");
		}

		//撤回台账数据
		List<RentEquipmentStartSubEntity> outRentEquipmentStartSubEntityList = startEntity.getRentEquipmentStartSubList();
		List<Long> outRentParameterIds = outRentEquipmentStartSubEntityList.stream().map(RentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
		logger.info("推送台账数据parameterIdList：{}", JSONObject.toJSONString(outRentParameterIds));

		//查询台账子表数据，如果最新的数据的sourceId不是当前单据的id则不能撤回。
		QueryParam param = new QueryParam();
		param.getParams().put("parameter_id", new Parameter(QueryParam.IN, outRentParameterIds));
		param.getOrderMap().put("create_time", QueryParam.DESC);
		List<RentParameterDetailEntity> outRentParameterDetailEntityList = rentParameterDetailService.queryList(param);
		logger.info("查询台账子表数据outRentParameterDetailEntityList：{}", JSONObject.toJSONString(outRentParameterDetailEntityList));
		logger.info("entity.getId()：{}，billId：{}，sourceId：{}，entity：{}", startEntity.getId(), billId, outRentParameterDetailEntityList.get(0).getSourceId(),  JSONObject.toJSONString(startEntity));
		if (EntranceRentFlagEnum.否.getCode().equals(startEntity.getEntranceRentFlag())){
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(outRentParameterDetailEntityList) && !startEntity.getId().equals(outRentParameterDetailEntityList.get(0).getSourceId())){
				return CommonResponse.error("当前单据的设备，已被下游单据" + RentParameterTypeEnum.getEnumByCode(outRentParameterDetailEntityList.get(0).getSourceType()).getDescription() + "引用，不能撤回！");
			}
		}else {
			//如果是进场启用
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(outRentParameterDetailEntityList) && !RentEquipmentStateEnum.启用.getCode().equals(outRentParameterDetailEntityList.get(0).getEquipmentState())){
				return CommonResponse.error("当前单据的设备，已被下游单据" + RentParameterTypeEnum.getEnumByCode(outRentParameterDetailEntityList.get(0).getSourceType()).getDescription() + "引用，不能撤回！");
			}
		}

		if (EntranceRentFlagEnum.是.getCode().equals(startEntity.getEntranceRentFlag())){
			//初次进场启用   1，更新主表状态为待启用，计租日期为空，操作时间为最新
			UpdateWrapper<RentParameterEntity> updateWrapper = new UpdateWrapper<>();
			updateWrapper.in("id", outRentParameterIds);
			updateWrapper.set("meter_rent_date", null);
			updateWrapper.set("start_date", null);
			updateWrapper.set("operation_date", new Date());
			updateWrapper.set("equipment_state", RentEquipmentStateEnum.待启用.getCode());
			rentParameterService.update(updateWrapper);

			//更新子表操作时间为null
			UpdateWrapper<RentParameterDetailEntity> detailUpdateWrapper = new UpdateWrapper<>();
			detailUpdateWrapper.in("parameter_id", outRentParameterIds);
			detailUpdateWrapper.set("operation_date", null);
			rentParameterDetailService.update(detailUpdateWrapper);
		}else{
			//进场启用为否  保持原有逻辑
			rentParameterService.cancelParameter(outRentParameterIds, RentParameterTypeEnum.启用单.getCode(), startEntity.getId());
		}


		//推送供方
		//对单据进行加锁
		//CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		//if (!ejcCloudSystemCode.isSuccess()) {
		//	throw new BusinessException("获取当前系统编码失败！");
		//}
		//Map<String,Object> map = new HashMap<>();
		//map.put("sourceId",billId);
		//map.put("systemId",ejcCloudSystemCode.getData());
		//String dataInfo = JSONObject.toJSONString(map);
		//Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
		//		startEntity.getSupplierId().toString(),OPERATE,BILL_TYPE);
		//if (!updateSupplierStatus){
		//	throw new BusinessException("单据推送失败！");
		//}
		startEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		rentEquipmentStartService.saveOrUpdate(startEntity,false);

		return CommonResponse.success();
	}

}
