package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ac.service.IContractDetailService;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.vo.SettleOtherVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.settle.bean.SettleOtherEntity;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 结算实体
 *
 * @author generator
 */
@RestController
@RequestMapping("settle")
public class SettleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISettleOtherService otherService;
    private static final String BILL_CODE = "OTH_SETTLE";//此处需要根据实际修改

    @Autowired
    private ISettleService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if (entity.getId() == null) {
            //如果编码为空，就新增编码
            if(StringUtils.isBlank(entity.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }


        }else {
            SettleEntity oldSettleEntity = service.selectById(entity.getId());
            if (StringUtils.isBlank(entity.getBillCode())){
                entity.setBillCode(oldSettleEntity.getBillCode());
            }else {
                //验证编码是否唯一
                if (checkSameBillCode(BeanMapper.map(entity, ContractVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }
        service.saveOrUpdate(entity, false);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("同步结算池接口")
    @RequestMapping(value = "/syncSettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushSettle(@RequestParam Long id) {
        SettleEntity entity = service.selectById(id);
        boolean pool = service.pushSettleToPool(BeanMapper.map(entity,SettleVO.class));
        if(!pool){
            throw new BusinessException("推送结算池失败");
        }
        return CommonResponse.success("同步成功");
    }
    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO settleVO) {
        return service.pushCost(settleVO);
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(SettleEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(SettleEntity::getId, contractVO.getId());
        }
        return service.list(lambda).size() > 0;
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = service.selectById(id);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        service.removeByIds(vos.stream().map(SettleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SettleVO> settleVOS = BeanMapper.mapList(page.getRecords(), SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType()==1){
                vo.setSettleTypeStr("完工结算");
            }else if (vo.getSettleType()==0){
                vo.setSettleTypeStr("过程结算");
            }
        });
        pageData.setRecords(settleVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例  结算单编号、项目名称、合同名称、甲方经办人*/
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettleEntity> list = service.queryList(param);
        List<SettleVO> voList = BeanMapper.mapList(list, SettleVO.class);
        // 字段翻译
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (vo.getSettleType()==1){
                vo.setSettleTypeStr("完工结算");
            }else if (vo.getSettleType()==0){
                vo.setSettleTypeStr("过程结算");
            }
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("settle-pro-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
//     * @param contractId
     * @Description queryUnusedContract 查询合同是否被当前结算类型所使用
     * 是否有审批中的单据，如果有不允许进行完工结算
     */
    @ResponseBody
    @RequestMapping(value = "/queryUnusedContract", method = RequestMethod.POST)
    public CommonResponse<SettleVO> queryUnusedContract(@RequestBody SettleVO settleVO) {
        return service.queryUnusedContract(settleVO.getContractId(),settleVO.getSettleDate(),settleVO.getSettleType());
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 其他费用参照
     */
    @RequestMapping(value = "/refSettleOtherData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleOtherVO>> refOtherData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                             @RequestParam(defaultValue = "10") Integer pageSize,
                                                             @RequestParam(value = "condition", required = false) String condition,
                                                             @RequestParam(value = "searchObject", required = false) String searchObject,
                                                             @RequestParam(value = "searchText", required = false) String searchText) {
        Integer settleType = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page<SettleOtherEntity> pg = new Page<>(pageNumber, pageSize);
        IPage<SettleOtherEntity> page = otherService.selectPageOther(pg, settleType, contractId);
        IPage<SettleOtherVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleOtherVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 分包清单（合同）参照
     */
    @RequestMapping(value = "/refSettleDetailData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleDetailVO>> refDetailData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                                               @RequestParam(value = "condition", required = false) String condition,
                                                               @RequestParam(value = "searchObject", required = false) String searchObject,
                                                               @RequestParam(value = "searchText", required = false) String searchText) {
        Integer settleType = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }

        Page<SettleDetailEntity> pg = new Page<>(pageNumber, pageSize);
        IPage<SettleDetailEntity> page = detailService.selectPageDetail(pg, settleType, contractId, searchText);
        IPage<SettleDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleDetailVO.class));
       /* LambdaQueryWrapper<ContractDetailEntity> query = new LambdaQueryWrapper<>();
        query.eq(ContractDetailEntity::getContractId, contractId);
        query.eq(ContractDetailEntity::getDr,0);
        List<ContractDetailEntity> entity = contractDetailService.list(query);
        for (SettleDetailVO vo : pageData.getRecords()){
            for (int i=0;i <= entity.size();i++){
                vo.setSourceBillCode(entity.get(i).getEquipmentCode());
                vo.setDetailName(entity.get(i).getCategoryName());
                vo.setSpecificationType(entity.get(i).getSpec());
            }
        }*/
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 查询合同结算记录
     *
     * @param id         合同Id
     * @param settleType 结算类型
     * @return
     */
    @GetMapping(value = "/queryDetailRecord")
    public CommonResponse<SettleRecordVO> queryDetailRecord(@RequestParam(value = "id") Long id,
                                                            @RequestParam(value = "settleType") Integer settleType) {
        SettleRecordVO vo = service.queryDetailRecord(id, settleType);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询最新结算单日期
     *
     * @param contractId         合同Id
     * @param
     * @return
     */
    @GetMapping(value = "/queryDeta")
    public CommonResponse<Map> queryDeta(@RequestParam(value = "contractId") Long contractId) {
        LambdaQueryWrapper<SettleEntity>query=new LambdaQueryWrapper<>();
        query.eq(SettleEntity::getContractId,contractId);
        query.orderByDesc(SettleEntity::getCreateTime);
        query.in(SettleEntity::getBillState,1,3);
        List<SettleEntity> entities = service.list(query);
        Date createTime;
        if(CollectionUtils.isNotEmpty(entities)){
            createTime = entities.get(0).getCreateTime();
        }else{
            createTime = null;
        }
        Map<String, Object> map = new HashMap<>();
        map.put("createTime",createTime);
        map.put("settlementNum",entities.size());
        return CommonResponse.success("查询详情数据成功！", map);

    }

    /**
     * 单据管控-累计结算金额大于合同金额
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody SettleVO settleVO) {
        return CommonResponse.success("参数校验成功！", service.checkParams(settleVO));
    }
    /**
     * 目标成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return service.pushTargetCost(id);
    }

}
