package com.ejianc.business.settle.service;

import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 结算实体
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    /**
     * @Description queryUnusedContract 查询合同是否被完工使用
     * @param contractId
     */
    CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType);

    /**
     * 查询合同对应类型的结算记录
     *
     * @param contractId
     * @param settleType
     * @return
     */
    SettleRecordVO queryDetailRecord(Long contractId, Integer settleType);


    /**
     * 新增合同结算前校验
     *
     * @param contractId
     * @param settleType
     * @return
     */
    String beforeNewSettleCheck(Long contractId, Integer settleType);

   // boolean pushSettleToPool(SettleVO settleVO);
    /*
    *推送至结算池
    */
    boolean pushSettleToPool(SettleVO vo);
    ParamsCheckVO checkParams(SettleVO vo);
    /*
     * 合同金额控结算金额
     * */
    List<ParamsCheckVO> checkParamsMny(ContractEntity contractEntity, SettleVO vo);
    /*
    *从结算池中删除数据
    */
    boolean delSettleFromPool(Long id);

    ExecutionVO targetCost(SettleVO settleVO, String linkUrl);

    CommonResponse<SettleVO> pushCost(SettleVO settleVO);

    void costPush(SettleEntity settleEntity);

    CommonResponse<String> pushTargetCost(Long id);

    void updateContractPoolSettle(SettleVO vo, Boolean type);
}
