package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("settle")
public class SettleBpmServiceImpl implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //结算单  根据 合同状态校验
        SettleEntity entity = service.selectById(billId);
        if(entity.getContractId()!=null){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getPerformanceStatus())){
                throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
            }
        }
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {

        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        //结算单  根据 合同状态校验
        SettleEntity entity = service.selectById(billId);
        if(entity.getContractId()!=null){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getPerformanceStatus())){
                throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
            }
        }
        return bpmBackCheck(billId, state, billTypeCode);
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        //最终结算撤回删除结算单推过的数据
        SettleEntity settleEntity = service.selectById(billId);
        //最终结算撤回时 已提交撤回才删除，中途撤回操作，结算单未生效，还未推送成本科目
        if (settleEntity.getSettleType() == 1 && (settleEntity.getBillState() == 1 || settleEntity.getBillState() == 3)) {
            //推送目标成本
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            //  List<ContractEntity>  contractEntityList = new ArrayList<>();
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, SettleVO.class), "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        //结算单  根据 合同状态校验
        SettleEntity entity = service.selectById(billId);
        if(entity.getContractId()!=null){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getPerformanceStatus())){
                throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
            }
        }
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        //结算单  根据 合同状态校验
        SettleEntity entity = service.selectById(billId);
        if(entity.getContractId()!=null){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getPerformanceStatus())){
                throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription()+"不可进行此操作！");
            }
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);
        if (settleEntity != null) {
            settleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            //直审时添加单据提交人等信息
            UserContext userContext = sessionManager.getUserContext();
            settleEntity.setCommitDate(new Date());
            settleEntity.setCommitUserCode(userContext.getUserCode());
            settleEntity.setCommitUserName(userContext.getUserName());
        }
        //推送结算池
        boolean poolRes = service.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
        settleEntity.setPushPoolFlag(poolRes ? BillPushStatusEnum.推送成功.getStatus() : BillPushStatusEnum.未成功推送.getStatus());

        service.saveOrUpdate(settleEntity, false);
        //推送实际成本
        service.costPush(settleEntity);
        //推送合同池
        service.updateContractPoolSettle(BeanMapper.map(settleEntity,SettleVO.class), true);
        if (settleEntity.getSettleType() == 1) {
            // 完工结算修改合同状态为已封账
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
            List<ContractEntity> contractEntities = contractService.queryList(param, false);
            contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());
            logger.info("======完工结算终审审核完回调,已终止======,{}", JSONObject.toJSONString(contractEntities.get(0)));
            contractService.saveOrUpdate(contractEntities.get(0), false);
            //最终结算单生效推送目标成本
            String linkUrl;
            linkUrl = BaseHost + "ejc-proequipment-frontend/#/settleList/card?id=" + settleEntity.getId();
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, SettleVO.class), linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }

            return CommonResponse.success("完工结算终审回调成功！");
        }
        else {
            return CommonResponse.success("过程结算终审回调成功！");
        }
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        //最终结算撤回删除结算单推过的数据
        SettleEntity settleEntity = service.selectById(billId);
        //最终结算撤回时 已提交撤回才删除，中途撤回操作，结算单未生效，还未推送成本科目
        if (settleEntity.getSettleType() == 1 && (settleEntity.getBillState() == 1 || settleEntity.getBillState() == 3)) {
            //推送目标成本
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            //  List<ContractEntity>  contractEntityList = new ArrayList<>();
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, SettleVO.class), "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            logger.info("最终结算弃审后目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
            //修改合同状态  结算类型，0-过程,1-最终
            ContractEntity contractEntity = contractService.selectById(settleEntity.getContractId());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
            contractService.saveOrUpdate(contractEntity);
            ContractVO vo = BeanMapper.map(contractEntity, ContractVO.class);
            vo.setFinishSettleDate(null);
            contractService.pushContract(vo);//修改了合同 从新推送合同池
            logger.info("修改合同状态！" + JSONObject.toJSONString(contractEntity));
        }
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

        logger.info("完工单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
        // 签章流程校验
        SettleEntity settleEntity = service.selectById(billId);
        if (settleEntity == null) {
            return CommonResponse.error("查询不到该单据信息！");
        }
        //合同是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error("当前单据已被下游业务引用，不能弃审/撤回！");
        }
        //若当前合同有其他结算的自由态的结算单，也不能弃审/撤回！
        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
        settleLambda.ne(SettleEntity::getId, billId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = service.list(settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，不能弃审/撤回!");
        }

        //若当前结算单不是最新的，则不能弃审/撤回
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<SettleEntity> settleList = service.queryList(param);
        logger.info("查询过程结算信息：contractId-" + settleEntity.getContractId());
        if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)) {
            logger.info("查询最新的过程结算结果：{}", JSONObject.toJSONString(settleList.get(0), SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            SettleEntity processSettle = settleList.get(0);
            logger.info("nodeSettle.id-" + processSettle.getId());
            logger.info("billId-" + billId);
            if (!processSettle.getId().equals(billId)) {
                return CommonResponse.error("当前单据已有新的结算单，不能弃审/撤回！");
            }
        }
        // 从结算池中删除数据
        boolean unPushRes = service.delSettleFromPool(settleEntity.getId());
        if (unPushRes) {
            settleEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        else {
            logger.error("将过程结算单-{}从结算池删除失败！", settleEntity);
        }
        //推送合同池
        service.updateContractPoolSettle(BeanMapper.map(settleEntity,SettleVO.class), false);
        //如果是完工结算 就去修改合同状态
        if (settleEntity.getSettleType() == 1) {
            logger.info("完工结算弃审/撤回前回调结算实体信息为：{}", JSONObject.toJSONString(settleEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            // 完工结算撤回修改合同状态为履约中
            QueryParam qq = new QueryParam();
            qq.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
            List<ContractEntity> contractEntities = contractService.queryList(qq, false);
            contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
            logger.info("======完工结算弃审前回调,修改合同状态为履约中======,{}", JSONObject.toJSONString(contractEntities.get(0)));
            contractService.saveOrUpdate(contractEntities.get(0), false);
        }
        else {
            //当前合同是否有最终结算
            LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
            lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
            int resultCount = service.count(lambda);
            logger.info("查询最终结算信息：contractId-" + settleEntity.getContractId());
            logger.info("查询最终结算结果：resultCount-" + resultCount);
            if (resultCount > 0) {
                return CommonResponse.error("当前单据所用合同已被完工结算引用，不能弃审/撤回！");
            }
        }
        service.saveOrUpdate(settleEntity, false);
        logger.info("弃审推送成本---");
        logger.info("删除成本中心之前的数据-Id---{}",settleEntity.getId());
        CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(settleEntity.getId());
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, "0");//(1:是，0：否)
        updateWrapper.set(SettleEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
        service.update(updateWrapper);
        return CommonResponse.success("弃审/撤回前校验回调成功！");
    }
}
