/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity.getSettleType() == 1 && (settleEntity.getBillState() == 1 || settleEntity.getBillState() == 3)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO = this.service.targetCost((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        boolean poolRes;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity != null) {
            settleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            settleEntity.setCommitDate(new Date());
            settleEntity.setCommitUserCode(userContext.getUserCode());
            settleEntity.setCommitUserName(userContext.getUserName());
        }
        settleEntity.setPushPoolFlag((poolRes = this.service.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class))) ? BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus() : BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)settleEntity, false);
        this.service.costPush(settleEntity);
        this.service.updateContractPoolSettle((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), true);
        if (settleEntity.getSettleType() == 1) {
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("eq", (Object)settleEntity.getContractId()));
            List contractEntities = this.contractService.queryList(param, false);
            ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
            this.logger.info("======\u5b8c\u5de5\u7ed3\u7b97\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u7ec8\u6b62======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
            this.contractService.saveOrUpdate(contractEntities.get(0), false);
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
            String linkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/settleList/card?id=" + settleEntity.getId();
            ExecutionVO executionVO = this.service.targetCost((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            return CommonResponse.success((String)"\u5b8c\u5de5\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u8fc7\u7a0b\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity.getSettleType() == 1 && (settleEntity.getBillState() == 1 || settleEntity.getBillState() == 3)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO = this.service.targetCost((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            this.logger.info("\u6700\u7ec8\u7ed3\u7b97\u5f03\u5ba1\u540e\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(settleEntity.getContractId()));
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
            ContractVO vo = (ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
            vo.setFinishSettleDate(null);
            this.contractService.pushContract(vo);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u7ed3\u7b97Id---{}", (Object)settleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.updateCostDetail(settleEntity.getId(), Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)"0");
        updateWrapper.set(SettleEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        boolean unPushRes;
        this.logger.info("\u5b8c\u5de5\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u524d\u6821\u9a8c", new Object[]{billId, state, billTypeCode});
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
        settleLambda.ne(BaseEntity::getId, (Object)billId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = this.service.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode((Integer)((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!"));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)settleEntity.getContractId()));
        param.getOrderMap().put("create_time", "desc");
        List settleList = this.service.queryList(param);
        this.logger.info("\u67e5\u8be2\u8fc7\u7a0b\u7ed3\u7b97\u4fe1\u606f\uff1acontractId-" + settleEntity.getContractId());
        if (CollectionUtils.isNotEmpty((Collection)settleList) && null != settleList.get(0)) {
            this.logger.info("\u67e5\u8be2\u6700\u65b0\u7684\u8fc7\u7a0b\u7ed3\u7b97\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(settleList.get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            SettleEntity processSettle = (SettleEntity)((Object)settleList.get(0));
            this.logger.info("nodeSettle.id-" + processSettle.getId());
            this.logger.info("billId-" + billId);
            if (!processSettle.getId().equals(billId)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u65b0\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        if (unPushRes = this.service.delSettleFromPool(settleEntity.getId())) {
            settleEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            this.logger.error("\u5c06\u8fc7\u7a0b\u7ed3\u7b97\u5355-{}\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff01", (Object)settleEntity);
        }
        this.service.updateContractPoolSettle((SettleVO)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class), false);
        if (settleEntity.getSettleType() == 1) {
            this.logger.info("\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1/\u64a4\u56de\u524d\u56de\u8c03\u7ed3\u7b97\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            QueryParam qq = new QueryParam();
            qq.getParams().put("id", new Parameter("eq", (Object)settleEntity.getContractId()));
            List contractEntities = this.contractService.queryList(qq, false);
            ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.logger.info("======\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1\u524d\u56de\u8c03,\u4fee\u6539\u5408\u540c\u72b6\u6001\u4e3a\u5c65\u7ea6\u4e2d======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
            this.contractService.saveOrUpdate(contractEntities.get(0), false);
        } else {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
            lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
            int resultCount = this.service.count((Wrapper)lambda);
            this.logger.info("\u67e5\u8be2\u6700\u7ec8\u7ed3\u7b97\u4fe1\u606f\uff1acontractId-" + settleEntity.getContractId());
            this.logger.info("\u67e5\u8be2\u6700\u7ec8\u7ed3\u7b97\u7ed3\u679c\uff1aresultCount-" + resultCount);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6240\u7528\u5408\u540c\u5df2\u88ab\u5b8c\u5de5\u7ed3\u7b97\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        this.service.saveOrUpdate((Object)settleEntity, false);
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-Id---{}", (Object)settleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(settleEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)"0");
        updateWrapper.set(SettleEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

