package com.ejianc.business.ac.service;

import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.ac.bean.ContractEntity;

import java.util.List;
import java.util.Map;

/**
 * 安拆合同主实体
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

    ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType);

    ContractVO insertOrUpdate(ContractVO saveorUpdateVO, String authority);

    ContractVO queryDetail(Long id);

    Map<String, Object> countContractAmount(QueryParam param);

    Boolean addSupplementFlag(Long id);

    ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO);

    ContractVO addConvertByConId(Long contractId);

    ParamsCheckVO targetCostCtrl(ContractVO contractVo);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    /**
     * 删除附件
     * @param fileId
     * @param authority
     * @return
     */
    Boolean delContractFile(Long fileId, String authority);

    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    ContractVO querySupplementRecord(Long id);

    /**
     * 合同推送合同池
     *
     * @param contract
     * @return
     */
    boolean pushContract(ContractVO contract);

    /**
     * 将合同从合同池删除
     *
     * @param id
     * @return
     */
    boolean delContractFromPool(Long id);

    /**
     * 批量删除
     * @param vos
     * @return
     */
    CommonResponse<String> deleteByIds(List<ContractVO> vos);

    /**
     * 删除当前合同的合同附件
     * @param id
     * @return
     */
    Integer deleteContractFileById(Long id);

    CommonResponse<String> pushTargetCost(Long id);
    /**
     * 单据管控-补充协议金额大于合同金额
     * @return
     */
    List<ParamsCheckVO> checkParamsMnySup(ContractVO vo);

    ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2);

    boolean delWatermarkContractFile(Long watermarkFileId);

    /*施工合同 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    List<ParamsCheckVO> checkParamsConstruction(ContractVO vo);

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    String getContractFilingCode();

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    boolean checkContractFiling(Long contractId);

}
